/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.integration.jade;

import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum VendorBlockComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof VendorBlockEntity) {
            String text;
            int count;
            String product;
            CompoundTag serverData = accessor.getServerData();
            boolean hasProduct = serverData.contains("productName");
            boolean hasPrice = serverData.contains("priceName");
            if (hasProduct) {
                product = serverData.getString("productName");
                count = serverData.getInt("productCount");
                String string = text = count > 1 ? count + "x " + product : product;
                if (hasPrice) {
                    tooltip.add((Component)Component.translatable((String)"jade.vendingblock.sell", (Object[])new Object[]{text}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"jade.vendingblock.giveaway", (Object[])new Object[]{text}));
                }
            }
            if (hasPrice) {
                product = serverData.getString("priceName");
                count = serverData.getInt("priceCount");
                String string = text = count > 1 ? count + "x " + product : product;
                if (hasProduct) {
                    tooltip.add((Component)Component.translatable((String)"jade.vendingblock.buy", (Object[])new Object[]{text}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"jade.vendingblock.request", (Object[])new Object[]{text}));
                }
            }
            if (serverData.contains("owner")) {
                tooltip.add((Component)Component.translatable((String)"jade.vendingblock.owner", (Object[])new Object[]{serverData.getString("owner")}));
            }
            if (serverData.contains("hasError")) {
                boolean hasError = serverData.getBoolean("hasError");
                int errorCode = serverData.getInt("errorCode");
                if (hasError) {
                    switch (errorCode) {
                        case 1: {
                            tooltip.add((Component)Component.translatable((String)"jade.vendingblock.error.sold").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)12205116))));
                            break;
                        }
                        case 2: {
                            tooltip.add((Component)Component.translatable((String)"jade.vendingblock.error.full").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)12205116))));
                            break;
                        }
                        case 3: {
                            tooltip.add((Component)Component.translatable((String)"jade.vendingblock.error.empty").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)12205116))));
                            break;
                        }
                    }
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"vendor_component");
    }
}

