/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.components;

import com.furglitch.vendingblock.Config;
import com.furglitch.vendingblock.blockentity.DisplayBlockEntity;
import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import com.furglitch.vendingblock.gui.chat.Messages;
import com.furglitch.vendingblock.network.FilterSlotUpdatePacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class FilterSlot
extends SlotItemHandler {
    private final VendorBlockEntity vendorBlockEntity;
    private final DisplayBlockEntity displayBlockEntity;
    private final int slotIndex;
    private boolean triggeredByClick = false;

    public FilterSlot(IItemHandler handler, int index, int x, int y, VendorBlockEntity vendor) {
        super(handler, index, x, y);
        this.vendorBlockEntity = vendor;
        this.displayBlockEntity = null;
        this.slotIndex = index;
    }

    public FilterSlot(IItemHandler handler, int index, int x, int y, DisplayBlockEntity display) {
        super(handler, index, x, y);
        this.vendorBlockEntity = null;
        this.displayBlockEntity = display;
        this.slotIndex = index;
    }

    public void set(ItemStack stack) {
        if (!stack.isEmpty()) {
            if (this.slotIndex == 11 && !this.isFullBlock(stack)) {
                return;
            }
            ItemStack filter = stack.copy();
            if (this.slotIndex == 11) {
                filter.setCount(1);
            }
            super.set(filter);
            if (this.vendorBlockEntity != null) {
                if (this.slotIndex == 0) {
                    this.vendorBlockEntity.setFilterContents(1, filter);
                } else if (this.slotIndex == 10) {
                    this.vendorBlockEntity.setFilterContents(2, filter);
                } else if (this.slotIndex == 11) {
                    this.vendorBlockEntity.setFilterContents(3, filter);
                }
                if (!this.triggeredByClick && this.vendorBlockEntity.getLevel() != null && this.vendorBlockEntity.getLevel().isClientSide()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new FilterSlotUpdatePacket(this.vendorBlockEntity.getBlockPos(), this.slotIndex, filter), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (this.displayBlockEntity != null) {
                this.displayBlockEntity.inventory.setStackInSlot(this.slotIndex, filter);
            }
        } else {
            super.set(ItemStack.EMPTY);
            if (this.vendorBlockEntity != null) {
                if (this.slotIndex == 0) {
                    this.vendorBlockEntity.setFilterContents(1, ItemStack.EMPTY);
                } else if (this.slotIndex == 10) {
                    this.vendorBlockEntity.setFilterContents(2, ItemStack.EMPTY);
                } else if (this.slotIndex == 11) {
                    this.vendorBlockEntity.setFilterContents(3, ItemStack.EMPTY);
                }
                if (!this.triggeredByClick && this.vendorBlockEntity.getLevel() != null && this.vendorBlockEntity.getLevel().isClientSide()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new FilterSlotUpdatePacket(this.vendorBlockEntity.getBlockPos(), this.slotIndex, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (this.displayBlockEntity != null) {
                this.displayBlockEntity.inventory.setStackInSlot(this.slotIndex, ItemStack.EMPTY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onClick(ItemStack cursorStack, boolean leftClick) {
        this.triggeredByClick = true;
        try {
            if (this.vendorBlockEntity != null) {
                if (leftClick) {
                    if (cursorStack.isEmpty()) {
                        this.set(ItemStack.EMPTY);
                    } else {
                        if (this.slotIndex == 11 && (this.isBlacklistedFacade(cursorStack) || !this.isFullBlock(cursorStack))) {
                            boolean bl = false;
                            return bl;
                        }
                        if (this.slotIndex == 0 && this.isBlacklistedProduct(cursorStack)) {
                            boolean bl = false;
                            return bl;
                        }
                        slotStack = cursorStack.copy();
                        if (this.slotIndex == 11) {
                            slotStack.setCount(1);
                        } else {
                            slotStack.setCount(cursorStack.getCount());
                        }
                        this.set(slotStack);
                    }
                } else if (cursorStack.isEmpty()) {
                    this.set(ItemStack.EMPTY);
                } else {
                    if (this.slotIndex == 11 && (this.isBlacklistedFacade(cursorStack) || !this.isFullBlock(cursorStack))) {
                        boolean slotStack = false;
                        return slotStack;
                    }
                    if (this.slotIndex == 0 && this.isBlacklistedProduct(cursorStack)) {
                        boolean slotStack = false;
                        return slotStack;
                    }
                    slotStack = cursorStack.copy();
                    if (this.slotIndex == 11 || cursorStack.getItem() != this.getItem().getItem()) {
                        slotStack.setCount(1);
                    } else {
                        slotStack.setCount(this.getItem().getCount() + 1);
                    }
                    this.set(slotStack);
                }
            } else if (this.displayBlockEntity != null) {
                if (cursorStack.isEmpty()) {
                    this.set(ItemStack.EMPTY);
                } else {
                    if (this.isBlacklistedFacade(cursorStack) || !this.isFullBlock(cursorStack)) {
                        cursorStack = ItemStack.EMPTY;
                        boolean slotStack = false;
                        return slotStack;
                    }
                    slotStack = cursorStack.copy();
                    slotStack.setCount(1);
                    this.set(slotStack);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.triggeredByClick = false;
        }
    }

    private boolean isFullBlock(ItemStack stack) {
        VoxelShape shape;
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        BlockState state = block.defaultBlockState();
        Level blockGetter = null;
        BlockPos pos = null;
        if (this.vendorBlockEntity != null && this.vendorBlockEntity.getLevel() != null) {
            blockGetter = this.vendorBlockEntity.getLevel();
            pos = this.vendorBlockEntity.getBlockPos();
        } else if (this.displayBlockEntity != null && this.displayBlockEntity.getLevel() != null) {
            blockGetter = this.displayBlockEntity.getLevel();
            pos = this.displayBlockEntity.getBlockPos();
        }
        try {
            shape = blockGetter != null && pos != null ? state.getShape((BlockGetter)blockGetter, pos) : state.getShape(null, null);
        }
        catch (Exception e) {
            return false;
        }
        VoxelShape fullCube = Shapes.block();
        if (!shape.equals(fullCube)) {
            if (pos == null) {
                return false;
            }
            Player player = null;
            if (this.vendorBlockEntity != null && this.vendorBlockEntity.getLevel() != null) {
                player = this.vendorBlockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            } else if (this.displayBlockEntity != null && this.displayBlockEntity.getLevel() != null) {
                player = this.displayBlockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            }
            if (player != null && (this.vendorBlockEntity != null && !this.vendorBlockEntity.getLevel().isClientSide() || this.displayBlockEntity != null && !this.displayBlockEntity.getLevel().isClientSide())) {
                player.sendSystemMessage(Messages.fullBlockFacade(stack.getHoverName().getString()));
            }
            return false;
        }
        return true;
    }

    private boolean isBlacklistedProduct(ItemStack stack) {
        Item item = stack.getItem();
        String itemId = item.toString();
        List blacklist = (List)Config.Server.PRODUCT_BLACKLIST.get();
        boolean match = false;
        for (String entry : blacklist) {
            if (entry.equals(itemId) || ("minecraft:" + entry).equals(itemId)) {
                match = true;
            } else if (entry.contains("*")) {
                match = this.wildcardMatch(entry, itemId) || this.wildcardMatch("minecraft:" + entry, itemId);
            } else if (entry.startsWith("#")) {
                match = FilterSlot.isItemInTag(entry.substring(1), stack);
            }
            if (!match) continue;
            break;
        }
        if (match) {
            BlockPos pos = this.vendorBlockEntity != null ? this.vendorBlockEntity.getBlockPos() : (this.displayBlockEntity != null ? this.displayBlockEntity.getBlockPos() : null);
            Player player = null;
            if (this.vendorBlockEntity != null && this.vendorBlockEntity.getLevel() != null) {
                player = this.vendorBlockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            }
            if (player != null && this.vendorBlockEntity != null && !this.vendorBlockEntity.getLevel().isClientSide()) {
                player.sendSystemMessage(Messages.blacklistedFacade(stack.getHoverName().getString()));
            }
        }
        return match;
    }

    private boolean isBlacklistedFacade(ItemStack stack) {
        Item item = stack.getItem();
        String itemId = item.toString();
        List blacklist = (List)Config.Server.FACADE_BLACKLIST.get();
        boolean match = false;
        for (String entry : blacklist) {
            if (entry.equals(itemId) || ("minecraft:" + entry).equals(itemId)) {
                match = true;
            } else if (entry.contains("*")) {
                match = this.wildcardMatch(entry, itemId) || this.wildcardMatch("minecraft:" + entry, itemId);
            } else if (entry.startsWith("#")) {
                match = FilterSlot.isItemInTag(entry.substring(1), stack);
            }
            if (!match) continue;
            break;
        }
        if (match) {
            BlockPos pos = this.vendorBlockEntity != null ? this.vendorBlockEntity.getBlockPos() : (this.displayBlockEntity != null ? this.displayBlockEntity.getBlockPos() : null);
            Player player = null;
            if (this.vendorBlockEntity != null && this.vendorBlockEntity.getLevel() != null) {
                player = this.vendorBlockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            } else if (this.displayBlockEntity != null && this.displayBlockEntity.getLevel() != null) {
                player = this.displayBlockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            }
            if (player != null && (this.vendorBlockEntity != null && !this.vendorBlockEntity.getLevel().isClientSide() || this.displayBlockEntity != null && !this.displayBlockEntity.getLevel().isClientSide())) {
                player.sendSystemMessage(Messages.blacklistedFacade(stack.getHoverName().getString()));
            }
        }
        return match;
    }

    private boolean wildcardMatch(String pattern, String str) {
        String regex = pattern.replace("*", ".*");
        return str.matches(regex);
    }

    public static boolean isItemInTag(String tagString, ItemStack stack) {
        ResourceLocation tagId = ResourceLocation.tryParse((String)tagString);
        if (tagId == null) {
            return false;
        }
        TagKey itemTagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId);
        TagKey blockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId);
        ServerLevel level = null;
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            level = ServerLifecycleHooks.getCurrentServer().overworld();
        }
        if (level != null) {
            boolean result;
            boolean itemTagExists;
            RegistryAccess registryAccess = level.registryAccess();
            Registry itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
            Optional itemTag = itemRegistry.getTag(itemTagKey);
            boolean bl = itemTagExists = itemTag != null;
            if (itemTagExists && (result = stack.getItem().builtInRegistryHolder().is(itemTagKey))) {
                return true;
            }
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                boolean result2;
                boolean blockTagExists;
                BlockItem blockItem = (BlockItem)item;
                Registry blockRegistry = registryAccess.registryOrThrow(Registries.BLOCK);
                Optional blockTag = blockRegistry.getTag(blockTagKey);
                boolean bl2 = blockTagExists = blockTag != null;
                if (blockTagExists && (result2 = blockItem.getBlock().builtInRegistryHolder().is(blockTagKey))) {
                    return true;
                }
            }
        }
        return false;
    }

    public void onTake(Player player, ItemStack stack) {
    }

    public ItemStack remove(int amount) {
        return ItemStack.EMPTY;
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

