/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.admin;

import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.registry.BlockRegistry;
import com.furglitch.vendingblock.registry.MenuRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class VendorAdminMenu
extends AbstractContainerMenu {
    public final VendorBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public VendorAdminMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public VendorAdminMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)MenuRegistry.VENDOR_ADMIN_MENU.get(), containerId);
        this.blockEntity = (VendorBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addSlot((Slot)new FilterSlot((IItemHandler)this.blockEntity.inventory, 0, 62, 53, this.blockEntity));
        this.addSlot((Slot)new FilterSlot((IItemHandler)this.blockEntity.inventory, 10, 80, 53, this.blockEntity));
        this.addSlot((Slot)new FilterSlot((IItemHandler)this.blockEntity.inventory, 11, 98, 53, this.blockEntity));
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return VendorAdminMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockRegistry.VENDOR.get()));
    }

    private void addPlayerInventory(Inventory inv) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.slots.size() && (slot = (Slot)this.slots.get(slotId)) instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)slot;
            if (clickType == ClickType.PICKUP) {
                boolean leftClick;
                ItemStack cursorStack = this.getCarried();
                boolean bl = leftClick = dragType == 0;
                if (filterSlot.onClick(cursorStack, leftClick)) {
                    return;
                }
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }
}

