/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.player005.vegandelightfabric.VeganDelightMod;
import net.player005.vegandelightfabric.VeganDelightPlatform;
import net.player005.vegandelightfabric.fluids.FluidProperties;
import net.player005.vegandelightfabric.neoforge.VeganFluidHandler;

@Mod(value="vegandelight")
public class VeganDelightNeo {
    private static IEventBus eventBus;

    public VeganDelightNeo(IEventBus eventBus) {
        VeganDelightNeo.eventBus = eventBus;
        VeganDelightMod.initializeAll(new VDNeoforgePlatform());
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        for (VillagerTrade trade : VDNeoforgePlatform.registeredTrades) {
            if (event.getType() != trade.profession) continue;
            List levelTrades = (List)event.getTrades().get(trade.level);
            levelTrades.add(trade.itemListing);
        }
    }

    private static FluidType createFluidType(final String name) {
        FluidType.Properties properties = FluidType.Properties.create();
        FluidType fluidType = new FluidType(properties);
        IClientFluidTypeExtensions clientFluidExtensions = new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)VeganDelightMod.modID, (String)("block/" + name + "_still"));
            }

            public ResourceLocation getFlowingTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)VeganDelightMod.modID, (String)("block/" + name + "_flowing"));
            }
        };
        eventBus.addListener(arg_0 -> VeganDelightNeo.lambda$createFluidType$0(clientFluidExtensions, fluidType, arg_0));
        return fluidType;
    }

    private static /* synthetic */ void lambda$createFluidType$0(1 clientFluidExtensions, FluidType fluidType, RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)clientFluidExtensions, new FluidType[]{fluidType});
    }

    public static class VDNeoforgePlatform
    implements VeganDelightPlatform {
        public static final List<VillagerTrade> registeredTrades = new ArrayList<VillagerTrade>();

        @Override
        public <V, T extends V> Holder<T> register(Registry<V> registry, ResourceKey<V> rk, Supplier<T> supplier) {
            eventBus.addListener(event -> event.register(registry.key(), rk.location(), supplier));
            return DeferredHolder.create((ResourceKey)registry.key(), (ResourceLocation)rk.location());
        }

        @Override
        public void registerFluidTank(Holder<Item> item, Holder<Item> empty, Supplier<FlowingFluid> fluid, int millibuckets) {
            eventBus.addListener(e -> e.registerItem(Capabilities.FluidHandler.ITEM, (arg_0, arg_1) -> VDNeoforgePlatform.lambda$registerFluidTank$1(empty, (Supplier)fluid, millibuckets, arg_0, arg_1), new ItemLike[]{(ItemLike)item.value()}));
        }

        @Override
        public TagKey<Biome> undergroundBiomeTag() {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"c:underground"));
        }

        @Override
        public void registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ItemListing itemListing) {
            registeredTrades.add(new VillagerTrade(profession, level, itemListing));
        }

        @Override
        public void registerBiomeModifier(float minTemp, float maxTemp, TagKey<Biome> allowed, TagKey<Biome> denied, GenerationStep.Decoration step, ResourceKey<PlacedFeature> modifier) {
        }

        @Override
        public Supplier<FlowingFluid> registerFluids(String name, FluidProperties properties) {
            FluidType fluidType = VeganDelightNeo.createFluidType(name);
            AtomicReference stillRef = new AtomicReference();
            AtomicReference flowingRef = new AtomicReference();
            BaseFlowingFluid.Properties fluidProperties = new BaseFlowingFluid.Properties(() -> fluidType, stillRef::get, flowingRef::get).block(properties.block()).bucket(properties.bucket()).levelDecreasePerBlock(properties.levelDecreasePerBlock()).explosionResistance((float)properties.explosionResistance()).tickRate(properties.tickRate()).slopeFindDistance(properties.slopeFindDistance());
            this.register(NeoForgeRegistries.FLUID_TYPES, ResourceLocation.fromNamespaceAndPath((String)VeganDelightMod.modID, (String)name), () -> fluidType);
            this.register(BuiltInRegistries.FLUID, ResourceLocation.fromNamespaceAndPath((String)VeganDelightMod.modID, (String)name), () -> {
                flowingRef.set(new BaseFlowingFluid.Flowing(fluidProperties));
                return (BaseFlowingFluid.Flowing)flowingRef.get();
            });
            this.register(BuiltInRegistries.FLUID, ResourceLocation.fromNamespaceAndPath((String)VeganDelightMod.modID, (String)("flowing_" + name)), () -> {
                stillRef.set(new BaseFlowingFluid.Source(fluidProperties));
                return (BaseFlowingFluid.Source)stillRef.get();
            });
            return stillRef::get;
        }

        @Override
        public void registerCompostables() {
        }

        @Override
        public boolean isModLoaded(String name) {
            return ModList.get().isLoaded(name);
        }

        private static /* synthetic */ IFluidHandlerItem lambda$registerFluidTank$1(Holder empty, Supplier fluid, int millibuckets, ItemStack stack, Void __) {
            return new VeganFluidHandler(stack, (Item)empty.value(), true, (Fluid)fluid.get(), millibuckets);
        }
    }

    public record VillagerTrade(VillagerProfession profession, int level, VillagerTrades.ItemListing itemListing) {
    }
}

