/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.nio.FloatBuffer;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.api.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.lwjgl.BufferUtils;

public class RenderHelper {
    public static void drawLine(GuiGraphics guiGraphics, int xBegin, int yBegin, int xEnd, int yEnd, int color) {
        guiGraphics.fill(xBegin, yBegin, xEnd += xBegin == xEnd ? 1 : 0, yEnd += yBegin == yEnd ? 1 : 0, color);
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)guiGraphics.pose().last().pose());
        modelViewStack.translate((float)x, (float)y, 50.0f);
        modelViewStack.scale((float)(-scale), (float)scale, (float)scale);
        PoseStack mobPoseStack = new PoseStack();
        mobPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        mobPoseStack.mulPose(Axis.XN.rotationDegrees((float)Math.atan(pitch / 40.0) * 20.0f));
        livingEntity.yo = (float)Math.atan(yaw / 40.0) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.setYRot(yRot);
        livingEntity.setYRot(yRot);
        livingEntity.setXRot(xRot);
        livingEntity.yHeadRot = yRot;
        livingEntity.yHeadRotO = yRot;
        mobPoseStack.translate(0.0, livingEntity.getY(), 0.0);
        RenderSystem.applyModelViewMatrix();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderChest(GuiGraphics guiGraphics, float x, float y, float rotate, float scale, float lidAngle) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Resources.Vanilla.CHEST);
        guiGraphics.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().translate(x, y, 50.0f);
        guiGraphics.pose().mulPose(new Quaternionf(-160.0f, 1.0f, 0.0f, 0.0f));
        guiGraphics.pose().scale(scale, -scale, -scale);
        guiGraphics.pose().translate(0.5f, 0.5f, 0.5f);
        guiGraphics.pose().mulPose(new Quaternionf(rotate, 0.0f, 1.0f, 0.0f));
        guiGraphics.pose().translate(-0.5f, -0.5f, -0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        guiGraphics.pose().popPose();
    }

    public static void renderBlock(GuiGraphics guiGraphics, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x, y, z);
        guiGraphics.pose().scale(-scale, -scale, -scale);
        guiGraphics.pose().translate(-0.5f, -0.5f, 0.0f);
        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-30.0f));
        guiGraphics.pose().translate(0.5f, 0.0f, -0.5f);
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(rotate));
        guiGraphics.pose().translate(-0.5f, 0.0f, 0.5f);
        guiGraphics.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().translate(0.0f, 0.0f, -1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        mc.getBlockRenderer().renderSingleBlock(block, guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        bufferSource.endBatch();
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    public static void scissor(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        double scale = Minecraft.getInstance().getWindow().getGuiScale();
        double[] xyzTranslation = RenderHelper.getGLTranslation(guiGraphics, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.getInstance().getWindow().getHeight() - y) - xyzTranslation[1]));
        int scissorW = Math.round(w - x);
        int scissorH = Math.round(h - y);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        RenderSystem.enableScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)Math.max(0, scissorInfo.width), (int)Math.max(0, scissorInfo.height));
    }

    public static void stopScissor() {
        RenderSystem.disableScissor();
    }

    public static void drawTexture(GuiGraphics guiGraphics, int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderHelper.drawTexturedModalRect(guiGraphics, x, y, u, v, width, height, 0.0f);
    }

    public static double[] getGLTranslation(GuiGraphics guiGraphics, double scale) {
        Matrix4f matrix = guiGraphics.pose().last().pose();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.set(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }

    public static double getGuiScaleFactor() {
        return Minecraft.getInstance().getWindow().getGuiScale();
    }

    public static void drawTexturedModalRect(GuiGraphics guiGraphics, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)u * 0.00390625f, (float)(v + height) * 0.00390625f);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f);
        buffer.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * 0.00390625f, (float)v * 0.00390625f);
        buffer.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)u * 0.00390625f, (float)v * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }
}

