/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.config.NCRConfigEncryption;
import com.aizistral.nochatreports.common.encryption.Encryption;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.AdvancedWidgetTooltipHolder;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;

@Environment(value=EnvType.CLIENT)
public class EncryptionConfigScreen
extends Screen {
    private static final Component HEADER = Component.translatable((String)"gui.nochatreports.encryption_config.header");
    private static final Component KEY_DESC = Component.translatable((String)"gui.nochatreports.encryption_config.key_desc");
    private static final Component PASS_DESC = Component.translatable((String)"gui.nochatreports.encryption_config.passphrase_desc");
    private static final Component VALIDATION_OK = Component.translatable((String)"gui.nochatreports.encryption_config.validation_ok");
    private static final Component VALIDATION_FAILED = Component.translatable((String)"gui.nochatreports.encryption_config.validation_failed");
    private static final Component DICE_TOOLTIP = Component.translatable((String)"gui.nochatreports.encryption_config.dice_tooltip");
    private static final Component PASS_NOT_ALLOWED = Component.translatable((String)"gui.nochatreports.encryption_config.pass_not_allowed");
    private static final Component ENCRYPT_PUBLIC = Component.translatable((String)"gui.nochatreports.encryption_config.encrypt_public");
    private static final ResourceLocation CROSSMARK = ResourceLocation.fromNamespaceAndPath((String)"nochatreports", (String)"encryption/crossmark_big");
    private static final int FIELDS_Y_START = 45;
    private final Screen previous;
    private CustomEditBox keyField;
    private CustomEditBox passField;
    private AdvancedImageButton validationIcon;
    private CycleButton<Encryption> algorithmButton;
    private MultiLineLabel keyDesc = MultiLineLabel.EMPTY;
    private MultiLineLabel passDesc = MultiLineLabel.EMPTY;
    protected Checkbox encryptPublicCheck;
    private boolean settingPassKey = false;

    public EncryptionConfigScreen(Screen previous) {
        super(CommonComponents.EMPTY);
        this.previous = previous;
    }

    private NCRConfigEncryption getConfig() {
        return NCRConfig.getEncryption();
    }

    protected void init() {
        this.clearWidgets();
        super.init();
        int w = (int)((double)this.width * (this.hugeGUI() ? 0.9 : 0.7));
        this.keyDesc = MultiLineLabel.create((Font)this.font, (Component)KEY_DESC, (int)(w - 5));
        int keyDescSpace = (this.keyDesc.getLineCount() + 1) * this.getLineHeight();
        this.passDesc = MultiLineLabel.create((Font)this.font, (Component)PASS_DESC, (int)(w - 5));
        int passDescSpace = (this.passDesc.getLineCount() + 1) * this.getLineHeight();
        this.keyField = new CustomEditBox(this.font, (this.width - (w -= 52)) / 2 - 2, (this.hugeGUI() ? 25 : 45) + keyDescSpace - 15, w, 18, CommonComponents.EMPTY);
        this.keyField.setMaxLength(512);
        this.keyField.setResponder(this::onKeyUpdate);
        this.addWidget((GuiEventListener)this.keyField);
        AdvancedImageButton button = new AdvancedImageButton(this.keyField.getX() + this.keyField.getWidth() - 15, this.keyField.getY() + 3, 12, 12, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/checkmark", false, false), GUIShenanigans.getSprites("encryption/crossmark", false, false)), btn -> {}, (Component)Component.empty(), this);
        button.setTooltip(new AdvancedTooltip(() -> this.validationIcon != null && this.validationIcon.getSpritesIndex() == 0 ? VALIDATION_OK : VALIDATION_FAILED).setMaxWidth(250));
        button.active = false;
        button.visible = true;
        this.validationIcon = button;
        this.addRenderableOnly((Renderable)this.validationIcon);
        button = new AdvancedImageButton(this.keyField.getX() - 22, this.keyField.getY() - 0, 18, 18, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/key_button", false, false), new WidgetSprites[0]), btn -> {}, (Component)Component.empty(), this);
        button.active = false;
        button.visible = true;
        this.addRenderableOnly((Renderable)button);
        button = new AdvancedImageButton(this.keyField.getX() + this.keyField.getWidth() + 4, this.keyField.getY() - 1, 23, 20, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/random_button"), new WidgetSprites[0]), btn -> {
            this.unfocusFields();
            this.keyField.setValue(((Encryption)this.algorithmButton.getValue()).getRandomKey());
        }, (Component)Component.empty(), this);
        button.setTooltip(new AdvancedTooltip(DICE_TOOLTIP).setMaxWidth(250));
        button.active = true;
        button.visible = true;
        this.addRenderableWidget((GuiEventListener)button);
        this.passField = new CustomEditBox(this.font, (this.width - (w += 25)) / 2 + 11, this.keyField.getY() + this.keyField.getHeight() + passDescSpace + (this.hugeGUI() ? -3 : 13), w, 18, CommonComponents.EMPTY);
        this.passField.setMaxLength(512);
        this.passField.setResponder(this::onPassphraseUpdate);
        this.addWidget((GuiEventListener)this.passField);
        button = new AdvancedImageButton(this.passField.getX() - 22, this.passField.getY() - 0, 18, 18, SwitchableSprites.of(GUIShenanigans.getSprites("encryption/lock_button", false, false), new WidgetSprites[0]), btn -> {}, (Component)Component.empty(), this);
        button.active = false;
        button.visible = true;
        this.addRenderableOnly((Renderable)button);
        int checkWidth = this.font.width((FormattedText)ENCRYPT_PUBLIC);
        this.encryptPublicCheck = Checkbox.builder((Component)ENCRYPT_PUBLIC, (Font)this.font).pos(this.width / 2 - checkWidth / 2 - 8, this.passField.getY() + 24).selected(NCRConfig.getEncryption().shouldEncryptPublic()).build();
        this.addRenderableWidget((GuiEventListener)this.encryptPublicCheck);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> {
            this.onDone();
            this.onClose();
        }).pos(this.width / 2 + 4, this.passField.getY() + 48).size(219, 20).build());
        CycleButton cycle = CycleButton.builder(value -> Component.translatable((String)"gui.nochatreports.encryption_config.algorithm", (Object[])new Object[]{Component.translatable((String)("algorithm.nochatreports." + value.getID() + ".name"))})).withValues(Encryption.getRegistered()).displayOnlyValue().withInitialValue((Object)this.getConfig().getAlgorithm()).withTooltip(value -> new AdvancedTooltip((Component)Component.translatable((String)("algorithm.nochatreports." + value.getID()))).setMaxWidth(250)).create(this.width / 2 - 4 - 218, this.passField.getY() + 48, 218, 20, CommonComponents.EMPTY, (cycleButton, value) -> {
            this.unfocusFields();
            this.onAlgorithmUpdate((Encryption)value);
        });
        cycle.tooltip = new AdvancedWidgetTooltipHolder(cycle.tooltip.get());
        this.algorithmButton = cycle;
        this.addRenderableWidget((GuiEventListener)this.algorithmButton);
        this.onAlgorithmUpdate((Encryption)this.algorithmButton.getValue());
        if (!StringUtil.isNullOrEmpty((String)this.getConfig().getEncryptionPassphrase())) {
            this.passField.setValue(this.getConfig().getEncryptionPassphrase());
        } else if (!StringUtil.isNullOrEmpty((String)this.getConfig().getEncryptionKey())) {
            if (!Objects.equals(this.getConfig().getEncryptionKey(), ((Encryption)this.algorithmButton.getValue()).getDefaultKey())) {
                this.keyField.setValue(this.getConfig().getEncryptionKey());
            } else {
                this.keyField.setValue("");
            }
        }
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        if (!this.passField.isActive()) {
            if (this.passField.isFocused()) {
                this.passField.setFocused(false);
            }
            this.passField.setEditable(false);
        }
        super.render(graphics, i, j, f);
        graphics.drawCenteredString(this.font, HEADER, this.width / 2, this.hugeGUI() ? 8 : 16, 0xFFFFFF);
        this.keyDesc.renderLeftAligned(graphics, this.keyField.getX() - 20, this.hugeGUI() ? 25 : 45, this.getLineHeight(), 0xFFFFFF);
        this.keyField.render(graphics, i, j, f);
        this.passDesc.renderLeftAligned(graphics, this.passField.getX() - 20, this.keyField.getY() + this.keyField.getHeight() + (this.hugeGUI() ? 12 : 28), this.getLineHeight(), 0xFFFFFF);
        this.passField.render(graphics, i, j, f);
        if (StringUtil.isNullOrEmpty((String)this.keyField.getValue()) && !this.keyField.isFocused()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.nochatreports.encryption_config.default_key", (Object[])new Object[]{((Encryption)this.algorithmButton.getValue()).getDefaultKey()}), this.keyField.getX() + 4, this.keyField.getY() + 5, 0x999999);
        }
        if (!this.passField.active) {
            graphics.drawString(this.font, PASS_NOT_ALLOWED, this.passField.getX() + 4, this.passField.getY() + 5, 0x999999);
            RenderSystem.enableDepthTest();
            graphics.blitSprite(CROSSMARK, this.passField.getX() - 20, this.passField.getY() + 3, 14, 13);
        }
    }

    private int getLineHeight() {
        if (this.hugeGUI()) {
            Objects.requireNonNull(this.minecraft.font);
            return (int)(9.0 * 1.5) + 1;
        }
        Objects.requireNonNull(this.minecraft.font);
        return 9 * 2;
    }

    private void onKeyUpdate(String key) {
        if (!this.settingPassKey) {
            this.passField.setValue("");
        }
        if (!StringUtil.isNullOrEmpty((String)key)) {
            this.validationIcon.useSprites(((Encryption)this.algorithmButton.getValue()).validateKey(key) ? 0 : 1);
        } else {
            this.validationIcon.useSprites(0);
        }
    }

    private void onPassphraseUpdate(String pass) {
        Encryption encryption = (Encryption)this.algorithmButton.getValue();
        this.settingPassKey = true;
        if (!StringUtil.isNullOrEmpty((String)pass)) {
            if (encryption.supportsPassphrases()) {
                this.keyField.setValue(encryption.getPassphraseKey(pass));
            }
        } else {
            this.onKeyUpdate(this.keyField.getValue());
        }
        this.settingPassKey = false;
    }

    private void onAlgorithmUpdate(Encryption encryption) {
        if (!encryption.supportsPassphrases()) {
            this.passField.setFocused(false);
            this.passField.active = false;
            this.passField.setEditable(false);
            this.onKeyUpdate(this.keyField.getValue());
        } else {
            this.passField.active = true;
            this.passField.setEditable(true);
            this.onPassphraseUpdate(this.passField.getValue());
        }
    }

    private void unfocusFields() {
        this.keyField.setFocused(false);
        this.passField.setFocused(false);
    }

    private void onDone() {
        NCRConfigEncryption config = NCRConfig.getEncryption();
        Encryption encryption = (Encryption)this.algorithmButton.getValue();
        config.setAlgorithm(encryption);
        config.setEncryptionKey(!StringUtil.isNullOrEmpty((String)this.keyField.getValue()) ? this.keyField.getValue() : encryption.getDefaultKey());
        config.setEncryptPublic(this.encryptPublicCheck.selected());
    }

    private boolean hugeGUI() {
        return this.height <= 270;
    }

    public void onClose() {
        this.minecraft.setScreen(this.previous);
    }

    private static class CustomEditBox
    extends EditBox {
        public CustomEditBox(Font font, int i, int j, int k, int l, Component component) {
            super(font, i, j, k, l, component);
        }

        public void setFocused(boolean bl) {
            super.setFocused(bl);
        }
    }
}

