/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlock;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndesiteDepositorBlockEntity
extends AbstractDepositorBlockEntity
implements MenuProvider,
WorldlyContainer {
    @NotNull
    private Coin coin = Coin.SPUR;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] NO_SLOTS = new int[0];
    @NotNull
    private ItemStack inputStack = ItemStack.EMPTY;

    public AndesiteDepositorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Coin coin = this.getCoin();
        Lang.builder((String)"numismatics").add(Component.translatable((String)"block.numismatics.andesite_depositor.tooltip.price", (Object[])new Object[]{1, Component.translatable((String)coin.getTranslationKey()).append((Component)Component.literal((String)(" " + coin.fontChar)).withStyle(ChatFormatting.WHITE)), coin.value}).withStyle(coin.rarity.color())).forGoggles(tooltip);
        return true;
    }

    public void setCoin(@NotNull Coin coin) {
        this.coin = coin;
    }

    @NotNull
    public Coin getCoin() {
        return this.coin;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.numismatics.andesite_depositor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new AndesiteDepositorMenu((MenuType)NumismaticsMenuTypes.ANDESITE_DEPOSITOR.get(), i, inventory, this);
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (!this.inputStack.isEmpty()) {
            tag.put("InputStack", this.inputStack.save(registries));
        }
        tag.putInt("Coin", this.coin.ordinal());
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inputStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("InputStack"));
        int coinIdx = 0;
        if (tag.contains("ScrollValue", 3)) {
            coinIdx = tag.getInt("ScrollValue");
        } else if (tag.contains("Coin", 3)) {
            coinIdx = tag.getInt("Coin");
        }
        this.coin = Coin.values()[coinIdx];
    }

    @Override
    public void lazyTick() {
        if (this.level != null && !this.level.isClientSide) {
            Item item;
            if (!this.inputStack.isEmpty() && (item = this.inputStack.getItem()) instanceof CoinItem) {
                CoinItem coinItem = (CoinItem)item;
                this.inventory.add(coinItem.coin, this.inputStack.getCount());
                this.setChanged();
                if (coinItem.coin == this.getCoin()) {
                    this.activate();
                }
            }
            this.inputStack = ItemStack.EMPTY;
        }
        super.lazyTick();
    }

    protected boolean isContainerActive() {
        return (Boolean)this.getBlockState().getValue((Property)AndesiteDepositorBlock.LOCKED) == false && (Boolean)this.getBlockState().getValue((Property)AndesiteDepositorBlock.POWERED) == false;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        if (side == Direction.UP && this.isContainerActive()) {
            return SLOTS_FOR_UP;
        }
        return NO_SLOTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (!this.isContainerActive()) return false;
        if (direction != Direction.UP) return false;
        Item item = itemStack.getItem();
        if (!(item instanceof CoinItem)) return false;
        CoinItem coinItem = (CoinItem)item;
        if (coinItem.coin != this.getCoin()) return false;
        return true;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.isContainerActive() ? 1 : 0;
    }

    public boolean isEmpty() {
        return !this.isContainerActive() || this.inputStack.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.inputStack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        if (this.inputStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.inputStack.split(amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack ret = this.inputStack;
        this.inputStack = ItemStack.EMPTY;
        return ret;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.inputStack = stack;
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return false;
    }

    public void clearContent() {
        this.inputStack = ItemStack.EMPTY;
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        TrustListMenu.openMenu(this, player, NumismaticsBlocks.ANDESITE_DEPOSITOR.asStack());
    }
}

