/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.ithundxr.createnumismatics.base.block.ConditionalBreak;
import dev.ithundxr.createnumismatics.base.block.NotifyFailedBreak;
import dev.ithundxr.createnumismatics.content.backend.TrustedBlock;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBankerBlock
extends Block
implements IWrenchable,
IBE<BlazeBankerBlockEntity>,
TrustedBlock,
NotifyFailedBreak,
ConditionalBreak {
    public BlazeBankerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<BlazeBankerBlockEntity> getBlockEntityClass() {
        return BlazeBankerBlockEntity.class;
    }

    public BlockEntityType<? extends BlazeBankerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.BLAZE_BANKER.get();
    }

    @Override
    public void notifyFailedBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlazeBankerBlockEntity) {
            BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
            blazeBankerBE.notifyDelayedDataSync();
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    @Override
    public boolean mayBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        return this.mayBreak(level, pos, state, player, false);
    }

    private boolean mayBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player, boolean forDestroyProgress) {
        if (level.isClientSide() && !forDestroyProgress) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BlazeBankerBlockEntity)) {
            return true;
        }
        BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
        if (level.isClientSide()) {
            return blazeBankerBE.getClientsideBalance() == 0;
        }
        return !blazeBankerBE.hasAccount() || blazeBankerBE.getAccount().getBalance() == 0;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (be.owner == null) {
                be.owner = player.getUUID();
                be.notifyUpdate();
            }
        });
        if (this.isTrusted(player, (BlockGetter)level, pos)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.openTrustListMenu((ServerPlayer)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlazeBankerBlockEntity) {
                BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
                blazeBankerBE.owner = player.getUUID();
            }
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.getPlayer(), (BlockGetter)context.getLevel(), context.getClickedPos())) {
            return InteractionResult.FAIL;
        }
        return super.onSneakWrenched(state, context);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (context == CollisionContext.empty()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.getShape(state, level, pos, context);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        world.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        if (!this.isTrusted(player, level, pos) || !this.mayBreak((LevelAccessor)player.level(), pos, state, player, true)) {
            return 0.0f;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }
}

