/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.items;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesComponents;

public class PlaneItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    public final Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType;

    public PlaneItem(Item.Properties properties, Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType) {
        super(properties.stacksTo(1));
        this.planeEntityType = planeEntityType;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        CompoundTag entityTag = (CompoundTag)pStack.get(SimplePlanesComponents.ENTITY_TAG);
        if (entityTag != null) {
            Block block;
            if (entityTag.contains("material") && (block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)entityTag.getString("material")))) != null) {
                pTooltipComponents.add((Component)Component.translatable((String)"simpleplanes.material").append((Component)block.getName()));
            }
            if (entityTag.contains("upgrades")) {
                CompoundTag upgradesNBT = entityTag.getCompound("upgrades");
                for (String key : upgradesNBT.getAllKeys()) {
                    CompoundTag upgradeNbt = upgradesNBT.getCompound(key);
                    ResourceLocation resourceLocation = ResourceLocation.parse((String)key);
                    if (upgradeNbt.contains("desc")) {
                        pTooltipComponents.add((Component)Component.literal((String)upgradeNbt.getString("desc")));
                        continue;
                    }
                    pTooltipComponents.add((Component)Component.translatable((String)("name." + resourceLocation.toString().replace(":", "."))));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult hitResult = PlaneItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3d = playerIn.getViewVector(1.0f);
        List list = worldIn.getEntities((Entity)playerIn, playerIn.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = playerIn.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            CompoundTag entityTag;
            PlaneEntity planeEntity = (PlaneEntity)this.planeEntityType.get().create(worldIn);
            planeEntity.setPos(hitResult.getLocation().x(), hitResult.getLocation().y(), hitResult.getLocation().z());
            planeEntity.setYRot(playerIn.getYRot());
            planeEntity.yRotO = playerIn.yRotO;
            Component name = (Component)itemstack.get(DataComponents.CUSTOM_NAME);
            if (name != null) {
                planeEntity.setCustomName(name);
            }
            if ((entityTag = (CompoundTag)itemstack.get(SimplePlanesComponents.ENTITY_TAG)) != null) {
                planeEntity.readAdditionalSaveData(entityTag);
            }
            if (!worldIn.noCollision((Entity)planeEntity, planeEntity.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)planeEntity);
                if (!playerIn.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

