/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;

public class PlanePayloadReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<Item, PayloadEntry> payloadEntries = new HashMap<Item, PayloadEntry>();

    public PlanePayloadReloadListener() {
        super(GSON, "plane_payload");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        payloadEntries.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                CompoundTag compoundTag;
                JsonObject jsonObject = GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)"top element");
                Item item = Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)jsonObject.get("item").getAsString())), "missing item");
                Block renderBlock = Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)jsonObject.get("block").getAsString())), "missing block");
                EntityType dropSpawnEntity = Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)jsonObject.get("entity").getAsString())), "missing entity");
                if (jsonObject.has("entity_nbt")) {
                    String tag = GsonHelper.convertToString((JsonElement)jsonObject.get("entity_nbt"), (String)"entity_nbt");
                    compoundTag = TagParser.parseTag((String)tag);
                } else {
                    compoundTag = new CompoundTag();
                }
                payloadEntries.put(item, new PayloadEntry(item, renderBlock, dropSpawnEntity, compoundTag));
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading plane payload {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }
}

