/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat.jei;

import java.util.Arrays;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;

public class PlaneWorkbenchRecipeCategory
extends AbstractRecipeCategory<PlaneWorkbenchRecipe> {
    public static final RecipeType<PlaneWorkbenchRecipe> RECIPE_TYPE = RecipeType.create((String)"simpleplanes", (String)"plane_workbench", PlaneWorkbenchRecipe.class);

    public PlaneWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get().getName(), guiHelper.createDrawableItemLike((ItemLike)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get()), 125, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PlaneWorkbenchRecipe recipe, IFocusGroup focuses) {
        BuiltInRegistries.BLOCK.getTag(PlaneWorkbenchContainer.PLANE_MATERIALS_TAG).ifPresent(tag -> {
            Stream<ItemStack> materialStackStream = tag.stream().map(block -> new ItemStack((ItemLike)block.value(), recipe.materialAmount()));
            ((IRecipeSlotBuilder)builder.addInputSlot(1, 1).addIngredients(Ingredient.of(Arrays.stream(recipe.ingredient().getItems()).map(itemStack -> new ItemStack((ItemLike)itemStack.getItem(), recipe.ingredientAmount()))))).setStandardSlotBackground();
            ((IRecipeSlotBuilder)builder.addInputSlot(50, 1).addIngredients(Ingredient.of(materialStackStream))).setStandardSlotBackground();
            ((IRecipeSlotBuilder)builder.addOutputSlot(108, 1).addItemStack(recipe.result())).setStandardSlotBackground();
        });
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, PlaneWorkbenchRecipe recipe, IFocusGroup focuses) {
        builder.addRecipePlusSign().setPosition(27, 3);
        builder.addRecipeArrow().setPosition(76, 1);
    }
}

