/*
 * Decompiled with CFR 0.152.
 */
package com.axedgaming.endersdelight.blocks;

import com.axedgaming.endersdelight.blocks.EndstoneStoveBlock;
import com.axedgaming.endersdelight.blocks.FeastBlock;
import com.axedgaming.endersdelight.blocks.PieBlock;
import com.axedgaming.endersdelight.blocks.custom.AmberveilMushroom;
import com.axedgaming.endersdelight.blocks.custom.ChorusFlameBlock;
import com.axedgaming.endersdelight.blocks.custom.EtherealSaffronBush;
import com.axedgaming.endersdelight.blocks.custom.VoidpepperBush;
import com.axedgaming.endersdelight.items.ModItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"endersdelight");
    public static final Supplier<Block> CHORUS_PIE = BLOCKS.register("chorus_pie", () -> new PieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), ModItems.CHORUS_PIE_SLICE));
    public static final Supplier<Block> STUFFED_SHULKER_BLOCK;
    public static final Supplier<Block> CHORUS_CRATE;
    public static final Supplier<Block> ENDSTONE_STOVE;
    public static final Supplier<Block> ETHEREAL_SAFFRON_BUSH;
    public static final Supplier<Block> AMBERVEIL_MUSHROOM;
    public static final Supplier<Block> CHORUSFLAME_BUSH;
    public static final Supplier<Block> VOIDPEPPER_BUSH;

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    static {
        CHORUS_CRATE = BLOCKS.register("chorus_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
        ENDSTONE_STOVE = BLOCKS.register("endstone_stove", () -> new EndstoneStoveBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE_BRICKS).lightLevel(ModBlocks.litBlockEmission(13))));
        STUFFED_SHULKER_BLOCK = BLOCKS.register("stuffed_shulker_block", () -> new FeastBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHULKER_BOX), ModItems.STUFFED_SHULKER_BOWL, false));
        ETHEREAL_SAFFRON_BUSH = BLOCKS.register("ethereal_saffron_bush", () -> new EtherealSaffronBush(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).offsetType(BlockBehaviour.OffsetType.XZ)));
        AMBERVEIL_MUSHROOM = BLOCKS.register("amberveil_mushroom", () -> new AmberveilMushroom(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).noCollission().randomTicks().instabreak().pushReaction(PushReaction.DESTROY)));
        CHORUSFLAME_BUSH = BLOCKS.register("chorusflame_bush", () -> new ChorusFlameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).noCollission().randomTicks().instabreak().pushReaction(PushReaction.DESTROY)));
        VOIDPEPPER_BUSH = BLOCKS.register("voidpepper_bush", () -> new VoidpepperBush(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).noCollission().randomTicks().instabreak().pushReaction(PushReaction.DESTROY)));
    }
}

