/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.commons.lang3.StringUtils;

public final class AbstractLootProvider {
    private AbstractLootProvider() {
    }

    public static interface LootTableDataProvider
    extends DataProvider,
    LootTableSubProvider {
        public HolderLookup.Provider registries();

        public PackOutput.PathProvider pathProvider();

        public LootContextParamSet paramSet();

        public boolean skipValidationFor(ResourceKey<LootTable> var1);

        default public CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
            DefaultedMappedRegistry registry = new DefaultedMappedRegistry("empty", Registries.LOOT_TABLE, Lifecycle.experimental(), false);
            ResourceKey defaultKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)registry.getDefaultKey());
            registry.register(defaultKey, (Object)LootTable.EMPTY, RegistrationInfo.BUILT_IN);
            Object2ObjectOpenHashMap seeds = new Object2ObjectOpenHashMap();
            this.generate((arg_0, arg_1) -> this.lambda$run$0((Map)seeds, registry, arg_0, arg_1));
            registry.freeze();
            this.validate((Registry<LootTable>)registry);
            return CompletableFuture.allOf((CompletableFuture[])registry.entrySet().stream().filter(entry -> entry.getKey() != defaultKey).map(entry -> {
                ResourceKey resourceKey = (ResourceKey)entry.getKey();
                LootTable lootTable = (LootTable)entry.getValue();
                Path path = this.pathProvider().json(resourceKey.location());
                return DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)LootTable.DIRECT_CODEC, (Object)lootTable, (Path)path);
            }).toArray(CompletableFuture[]::new));
        }

        default public void validate(Registry<LootTable> registry) {
            ProblemReporter.Collector collector = new ProblemReporter.Collector();
            HolderGetter.Provider registries = new RegistryAccess.ImmutableRegistryAccess(List.of(registry)).freeze().asGetterLookup();
            ValidationContext validationContext = new ValidationContext((ProblemReporter)collector, LootContextParamSets.ALL_PARAMS, registries);
            registry.holders().forEach(holder -> this.validate((Holder.Reference<LootTable>)holder, validationContext));
            Multimap multimap = collector.get();
            if (!multimap.isEmpty()) {
                multimap.forEach((string, string2) -> LOGGER.warn("Found validation problem in {}: {}", string, string2));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
        }

        default public void validate(Holder.Reference<LootTable> holder, ValidationContext validationContext) {
            if (!this.skipValidationFor((ResourceKey<LootTable>)holder.key())) {
                ((LootTable)holder.value()).validate(validationContext.setParams(((LootTable)holder.value()).getParamSet()).enterElement("{" + String.valueOf(holder.key().location()) + "}", holder.key()));
            }
        }

        private /* synthetic */ void lambda$run$0(Map seeds, DefaultedMappedRegistry registry, ResourceKey resourceKey, LootTable.Builder builder) {
            ResourceLocation resourceLocation = resourceKey.location();
            ResourceLocation oldResourceLocation = seeds.put(RandomSequence.seedForKey((ResourceLocation)resourceLocation), resourceLocation);
            if (oldResourceLocation != null) {
                Util.logAndPauseIfInIde((String)("Loot table random sequence seed collision on " + String.valueOf(oldResourceLocation) + " and " + String.valueOf(resourceKey)));
            }
            builder.setRandomSequence(resourceLocation);
            LootTable lootTable = builder.setParamSet(this.paramSet()).build();
            registry.register(resourceKey, (Object)lootTable, RegistrationInfo.BUILT_IN);
        }
    }

    public static abstract class Simple
    implements LootTableDataProvider {
        private final Map<ResourceKey<LootTable>, LootTable.Builder> tables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
        private final Set<ResourceKey<LootTable>> skipValidation = new HashSet<ResourceKey<LootTable>>();
        private final LootContextParamSet paramSet;
        private final PackOutput.PathProvider pathProvider;
        private final CompletableFuture<HolderLookup.Provider> registries;
        private HolderLookup.Provider registryAccess;

        public Simple(LootContextParamSet paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput(), context.getRegistries());
        }

        public Simple(LootContextParamSet paramSet, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            this.paramSet = paramSet;
            this.pathProvider = packOutput.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
            this.registries = registries;
            this.registryAccess = RegistryAccess.EMPTY;
        }

        public CompletableFuture<?> run(CachedOutput output) {
            return this.registries.thenCompose(registries -> {
                this.registryAccess = registries;
                return this.run(output, (HolderLookup.Provider)registries).thenRun(() -> {
                    this.registryAccess = RegistryAccess.EMPTY;
                });
            });
        }

        public String getName() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> exporter) {
            this.addLootTables();
            this.tables.forEach(exporter);
        }

        @Override
        public HolderLookup.Provider registries() {
            Preconditions.checkState((this.registryAccess != RegistryAccess.EMPTY ? 1 : 0) != 0, (Object)"registry access is empty");
            return this.registryAccess;
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return this.paramSet;
        }

        @Override
        public boolean skipValidationFor(ResourceKey<LootTable> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation));
        }

        public void skipValidation(ResourceKey<LootTable> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        protected void add(ResourceKey<LootTable> table, LootTable.Builder builder) {
            this.tables.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends EntityLootSubProvider
    implements LootTableDataProvider {
        private final Set<ResourceKey<LootTable>> skipValidation = new HashSet<ResourceKey<LootTable>>();
        private final PackOutput.PathProvider pathProvider;
        private final CompletableFuture<HolderLookup.Provider> registries;
        private final String modId;

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput(), context.getRegistries());
        }

        public EntityTypes(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(FeatureFlags.REGISTRY.allFlags(), (HolderLookup.Provider)RegistryAccess.EMPTY);
            this.pathProvider = packOutput.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
            this.registries = registries;
            this.modId = modId;
        }

        public CompletableFuture<?> run(CachedOutput output) {
            return this.registries.thenCompose(registries -> {
                ((EntityLootSubProvider)this).registries = registries;
                return this.run(output, (HolderLookup.Provider)registries).thenRun(() -> {
                    ((EntityLootSubProvider)this).registries = RegistryAccess.EMPTY;
                });
            });
        }

        public String getName() {
            return "Entity Type Loot Tables";
        }

        public final void generate() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            this.generate();
            HashSet lootTables = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                EntityType entityType = (EntityType)holder.value();
                Map map = (Map)this.map.remove(entityType);
                if (this.canHaveLootTable(entityType)) {
                    ResourceKey resourceKey = entityType.getDefaultLootTable();
                    if (!(resourceKey.equals(BuiltInLootTables.EMPTY) || this.skipValidationFor((ResourceKey<LootTable>)resourceKey) || map != null && map.containsKey(resourceKey))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", resourceKey, holder.key().location()));
                    }
                    if (map != null) {
                        map.forEach((resourceLocation, builder) -> {
                            if (!lootTables.add(resourceLocation)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocation, holder.key().location()));
                            }
                            consumer.accept((ResourceKey<LootTable>)resourceLocation, (LootTable.Builder)builder);
                        });
                    }
                } else if (map != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(ResourceKey::location).map(ResourceLocation::toString).collect(Collectors.joining(",")), holder.key().location()));
                }
            });
            if (!this.map.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + String.valueOf(this.map.keySet()));
            }
        }

        @Override
        public HolderLookup.Provider registries() {
            Preconditions.checkState((((EntityLootSubProvider)this).registries != RegistryAccess.EMPTY ? 1 : 0) != 0, (Object)"registry access is empty");
            return ((EntityLootSubProvider)this).registries;
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return LootContextParamSets.ENTITY;
        }

        @Override
        public boolean skipValidationFor(ResourceKey<LootTable> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation));
        }

        public void skipValidation(ResourceKey<LootTable> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        public void skipValidation(EntityType<?> entityType) {
            this.skipValidation((ResourceKey<LootTable>)entityType.getDefaultLootTable());
        }

        protected boolean canHaveLootTable(EntityType<?> entityType) {
            return entityType.getCategory() != MobCategory.MISC;
        }

        protected Stream<Holder.Reference<EntityType<?>>> getRegistryEntries() {
            return BuiltInRegistries.ENTITY_TYPE.holders().filter(holder -> holder.key().location().getNamespace().equals(this.modId));
        }
    }

    public static abstract class Blocks
    extends BlockLootSubProvider
    implements LootTableDataProvider {
        private final Set<ResourceKey<LootTable>> skipValidation = new HashSet<ResourceKey<LootTable>>();
        private final PackOutput.PathProvider pathProvider;
        private final CompletableFuture<HolderLookup.Provider> registries;
        private final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput(), context.getRegistries());
        }

        public Blocks(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), (HolderLookup.Provider)RegistryAccess.EMPTY);
            this.pathProvider = packOutput.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
            this.registries = registries;
            this.modId = modId;
        }

        public CompletableFuture<?> run(CachedOutput output) {
            return ((CompletableFuture)((CompletableFuture)this.registries.thenApply(registries -> {
                ((BlockLootSubProvider)this).registries = registries;
                return ((BlockLootSubProvider)this).registries;
            })).thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries))).thenRun(() -> {
                ((BlockLootSubProvider)this).registries = RegistryAccess.EMPTY;
            });
        }

        public String getName() {
            return "Block Loot Tables";
        }

        public final void generate() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            this.generate();
            HashSet lootTables = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                ResourceKey resourceKey = ((Block)holder.value()).getLootTable();
                if (resourceKey != BuiltInLootTables.EMPTY && lootTables.add(resourceKey)) {
                    LootTable.Builder builder = (LootTable.Builder)this.map.remove(resourceKey);
                    if (builder != null) {
                        consumer.accept(resourceKey, builder);
                    } else if (!this.skipValidationFor((ResourceKey<LootTable>)resourceKey)) {
                        throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(resourceKey, holder.key().location()));
                    }
                }
            });
            if (!this.map.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
            }
        }

        @Override
        public HolderLookup.Provider registries() {
            Preconditions.checkState((((BlockLootSubProvider)this).registries != RegistryAccess.EMPTY ? 1 : 0) != 0, (Object)"registry access is empty");
            return ((BlockLootSubProvider)this).registries;
        }

        @Override
        public PackOutput.PathProvider pathProvider() {
            return this.pathProvider;
        }

        @Override
        public LootContextParamSet paramSet() {
            return LootContextParamSets.BLOCK;
        }

        @Override
        public boolean skipValidationFor(ResourceKey<LootTable> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(ResourceLocation resourceLocation) {
            this.skipValidation((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation));
        }

        public void skipValidation(ResourceKey<LootTable> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        public void skipValidation(Block block) {
            this.skipValidation((ResourceKey<LootTable>)block.getLootTable());
        }

        public void dropNothing(Block block) {
            this.add(block, Blocks.noDrop());
        }

        public void dropNameable(Block block) {
            this.add(block, arg_0 -> ((Blocks)this).createNameableBlockEntityTable(arg_0));
        }

        protected Stream<Holder.Reference<Block>> getRegistryEntries() {
            return BuiltInRegistries.BLOCK.holders().filter(holder -> holder.key().location().getNamespace().equals(this.modId));
        }
    }
}

