/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evenbetternether.block;

import net.mcreator.evenbetternether.procedures.NetherReedAdditionalPlacinggrowthConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class NetherReedBlock
extends SugarCaneBlock {
    public NetherReedBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().sound(SoundType.BAMBOO).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return NetherReedBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0).move(offset.x, offset.y, offset.z);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        boolean additionalCondition = true;
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            additionalCondition = NetherReedAdditionalPlacinggrowthConditionProcedure.execute(world, x, y, z);
        }
        return groundState.is((Block)this) || (groundState.is(Blocks.SOUL_SAND) || groundState.is(Blocks.SOUL_SOIL) || groundState.is(Blocks.GRAVEL) || groundState.is(Blocks.MAGMA_BLOCK) || groundState.is(Blocks.NETHERRACK)) && additionalCondition;
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.above())) {
            int i = 1;
            while (world.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 6) {
                int j = (Integer)blockstate.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)blockstate, (boolean)true)) {
                    if (j == 15) {
                        world.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos.above(), (BlockState)this.defaultBlockState());
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }
}

