/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseRoof
extends RoofBlock {
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)15.0, (double)15.99);
    protected static final VoxelShape BASE_BOTTOM = Block.box((double)0.0, (double)1.0, (double)0.0, (double)15.99, (double)15.99, (double)15.99);

    public BaseRoof(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)SHAPE, (Comparable)BaseRoof.getStairsShape((BlockGetter)access, pos, (Direction)state.getValue((Property)FACING), (Half)state.getValue((Property)HALF))) : super.updateShape(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.getBlockState(pos.relative(direction));
        if (BaseRoof.isBaseRoof(blockstate) && half == blockstate.getValue((Property)HALF) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != facing.getAxis() && BaseRoof.canTakeShape(direction1.getOpposite(), blockstate, reader, pos)) {
            return direction1 == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.getBlockState(pos.relative(direction.getOpposite()));
        if (BaseRoof.isBaseRoof(blockstate1) && half == blockstate1.getValue((Property)HALF) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != facing.getAxis() && BaseRoof.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.getBlockState(pos.relative(dir));
        return !BaseRoof.isBaseRoof(blockstate) || blockstate.getValue((Property)FACING) != state.getValue((Property)FACING) || blockstate.getValue((Property)HALF) != state.getValue((Property)HALF);
    }

    public static boolean isBaseRoof(BlockState state) {
        return state.getBlock() instanceof BaseRoof;
    }
}

