/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public final class PacketTooltipData
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketTooltipData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"villager_retraining_plus", (String)"tooltip_data"));
    public final Cost cost = new Cost();
    public final Afford afford = new Afford();
    public final VillagerInfo villager = new VillagerInfo();
    public final Cap cap = new Cap();
    public final Cfg cfg = new Cfg();
    public static final StreamCodec<FriendlyByteBuf, PacketTooltipData> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, PacketTooltipData>(){

        public PacketTooltipData decode(FriendlyByteBuf buf) {
            PacketTooltipData pkt = new PacketTooltipData();
            pkt.cost.item = PacketTooltipData.readNullableRL(buf);
            pkt.cost.baseCost = buf.readVarInt();
            pkt.cost.scaledCost = buf.readVarInt();
            pkt.cost.nextCostIfUsed = PacketTooltipData.readNullableInt(buf);
            pkt.cost.maxCostPossible = PacketTooltipData.readNullableInt(buf);
            pkt.afford.canAfford = buf.readBoolean();
            pkt.afford.source = buf.readUtf(16);
            pkt.villager.level = buf.readVarInt();
            pkt.villager.xp = buf.readVarInt();
            pkt.cap.enabled = buf.readBoolean();
            pkt.cap.remaining = buf.readVarInt();
            pkt.cap.cap = buf.readVarInt();
            pkt.cap.resetMode = buf.readUtf(16);
            pkt.cap.intervalSeconds = buf.readVarInt();
            pkt.cap.resetAnchorEpochMs = buf.readLong();
            pkt.cap.nextResetEpochMs = buf.readLong();
            pkt.cfg.version = buf.readVarInt();
            pkt.cfg.hash = buf.readVarInt();
            pkt.cfg.scaleByLevel = buf.readBoolean();
            pkt.cfg.preferWallet = buf.readBoolean();
            pkt.cfg.freeMode = buf.readBoolean();
            pkt.cfg.capEnabled = buf.readBoolean();
            return pkt;
        }

        public void encode(FriendlyByteBuf buf, PacketTooltipData pkt) {
            PacketTooltipData.writeNullableRL(buf, pkt.cost.item);
            buf.writeVarInt(pkt.cost.baseCost);
            buf.writeVarInt(pkt.cost.scaledCost);
            PacketTooltipData.writeNullableInt(buf, pkt.cost.nextCostIfUsed);
            PacketTooltipData.writeNullableInt(buf, pkt.cost.maxCostPossible);
            buf.writeBoolean(pkt.afford.canAfford);
            buf.writeUtf(pkt.afford.source == null ? "none" : pkt.afford.source, 16);
            buf.writeVarInt(pkt.villager.level);
            buf.writeVarInt(pkt.villager.xp);
            buf.writeBoolean(pkt.cap.enabled);
            buf.writeVarInt(pkt.cap.remaining);
            buf.writeVarInt(pkt.cap.cap);
            buf.writeUtf(pkt.cap.resetMode == null ? "NEVER" : pkt.cap.resetMode, 16);
            buf.writeVarInt(pkt.cap.intervalSeconds);
            buf.writeLong(pkt.cap.resetAnchorEpochMs);
            buf.writeLong(pkt.cap.nextResetEpochMs);
            buf.writeVarInt(pkt.cfg.version);
            buf.writeVarInt(pkt.cfg.hash);
            buf.writeBoolean(pkt.cfg.scaleByLevel);
            buf.writeBoolean(pkt.cfg.preferWallet);
            buf.writeBoolean(pkt.cfg.freeMode);
            buf.writeBoolean(pkt.cfg.capEnabled);
        }
    };

    private static void writeNullableRL(FriendlyByteBuf buf, ResourceLocation rl) {
        buf.writeBoolean(rl != null);
        if (rl != null) {
            buf.writeResourceLocation(rl);
        }
    }

    private static ResourceLocation readNullableRL(FriendlyByteBuf buf) {
        return buf.readBoolean() ? buf.readResourceLocation() : null;
    }

    private static void writeNullableInt(FriendlyByteBuf buf, Integer v) {
        buf.writeBoolean(v != null);
        if (v != null) {
            buf.writeVarInt(v.intValue());
        }
    }

    private static Integer readNullableInt(FriendlyByteBuf buf) {
        return buf.readBoolean() ? Integer.valueOf(buf.readVarInt()) : null;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static final class Cost {
        public ResourceLocation item;
        public int baseCost;
        public int scaledCost;
        public Integer nextCostIfUsed;
        public Integer maxCostPossible;
    }

    public static final class Afford {
        public boolean canAfford;
        public String source;
    }

    public static final class VillagerInfo {
        public int level;
        public int xp;
    }

    public static final class Cap {
        public boolean enabled;
        public int remaining;
        public int cap;
        public String resetMode;
        public int intervalSeconds;
        public long resetAnchorEpochMs;
        public long nextResetEpochMs;
    }

    public static final class Cfg {
        public int version;
        public int hash;
        public boolean scaleByLevel;
        public boolean preferWallet;
        public boolean freeMode;
        public boolean capEnabled;
    }
}

