/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;

public final class WalletBridge {
    private static volatile boolean lookedUp = false;
    private static volatile boolean lcPresent = false;
    private static final List<String> WALLET_HANDLER_CANDIDATES = Arrays.asList("io.github.lightman314.lightmanscurrency.common.wallet.WalletHandler", "lightmanscurrency.common.wallet.WalletHandler");
    private static final List<String> WALLET_ITEM_CANDIDATES = Arrays.asList("io.github.lightman314.lightmanscurrency.common.items.WalletItem", "lightmanscurrency.common.items.WalletItem");
    private static final List<String> WALLET_WRAPPER_CANDIDATES = Arrays.asList("io.github.lightman314.lightmanscurrency.common.wallet.WalletDataWrapper", "lightmanscurrency.common.wallet.WalletDataWrapper");
    private static Class<?> clsWalletHandler;
    private static Class<?> clsWalletItem;
    private static Class<?> clsWalletDataWrapper;
    private static Method mWalletHandler_get;
    private static Method mWalletHandler_getWallet;
    private static Method mWalletHandler_setChanged;
    private static Method mWalletItem_isWallet;
    private static Method mWalletItem_getDataWrapper;
    private static Method mWrapper_getContents;
    private static Method mWrapper_setContents;

    public static boolean isLCPresent() {
        if (!lookedUp) {
            lcPresent = ModList.get().isLoaded("lightmanscurrency");
            lookedUp = true;
            if (lcPresent) {
                Villager_retraining_plus.LOG().info("[VRP] Lightman's Currency detected (soft-integration active)");
                WalletBridge.bindReflectionHandles();
            }
        }
        return lcPresent;
    }

    public static boolean tryWithdrawFromWallet(ServerPlayer player, ResourceLocation coinId, int count) {
        try {
            ItemStack s;
            int i;
            if (!WalletBridge.isLCPresent()) {
                return false;
            }
            if (coinId == null || count <= 0) {
                return false;
            }
            if (!WalletBridge.areBound()) {
                Villager_retraining_plus.LOG().info("[VRP] LC wallet API not bound; falling back to inventory.");
                return false;
            }
            Item targetItem = (Item)BuiltInRegistries.ITEM.get(coinId);
            if (targetItem == null) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: item '{}' not found in registry.", (Object)coinId);
                return false;
            }
            Object handler = mWalletHandler_get.invoke(null, player);
            if (handler == null) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: WalletHandler.get(player) returned null.");
                return false;
            }
            Object walletStackObj = mWalletHandler_getWallet.invoke(handler, new Object[0]);
            if (!(walletStackObj instanceof ItemStack)) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: getWallet() did not return an ItemStack.");
                return false;
            }
            ItemStack walletStack = (ItemStack)walletStackObj;
            if (walletStack.isEmpty() || !((Boolean)mWalletItem_isWallet.invoke(null, walletStack)).booleanValue()) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: no valid wallet equipped.");
                return false;
            }
            Object wrapper = mWalletItem_getDataWrapper.invoke(null, walletStack);
            if (wrapper == null) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: getDataWrapper() returned null.");
                return false;
            }
            Object containerObj = mWrapper_getContents.invoke(wrapper, new Object[0]);
            if (!(containerObj instanceof Container)) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: getContents() did not return a Container.");
                return false;
            }
            Container container = (Container)containerObj;
            int remaining = count;
            int available = 0;
            for (i = 0; i < container.getContainerSize(); ++i) {
                s = container.getItem(i);
                if (s.isEmpty()) continue;
                if (s.getItem() == targetItem) {
                    available += s.getCount();
                }
                if (available >= count) break;
            }
            if (available < count) {
                Villager_retraining_plus.LOG().info("[VRP] LC withdraw: insufficient wallet coins. Need {}, have {}.", (Object)count, (Object)available);
                return false;
            }
            for (i = 0; i < container.getContainerSize() && remaining > 0; ++i) {
                s = container.getItem(i);
                if (s.isEmpty() || s.getItem() != targetItem) continue;
                int take = Math.min(remaining, s.getCount());
                s.shrink(take);
                remaining -= take;
            }
            mWrapper_setContents.invoke(wrapper, container, player);
            mWalletHandler_setChanged.invoke(handler, new Object[0]);
            Villager_retraining_plus.LOG().info("[VRP] LC wallet: withdrew {} x {}", (Object)count, (Object)coinId);
            return true;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] LC wallet withdraw failed (soft): {}", (Object)t.toString());
            return false;
        }
    }

    private static boolean areBound() {
        return mWalletHandler_get != null && mWalletHandler_getWallet != null && mWalletHandler_setChanged != null && mWalletItem_isWallet != null && mWalletItem_getDataWrapper != null && mWrapper_getContents != null && mWrapper_setContents != null;
    }

    private static void bindReflectionHandles() {
        try {
            clsWalletHandler = WalletBridge.tryLoadAny(WALLET_HANDLER_CANDIDATES);
            clsWalletItem = WalletBridge.tryLoadAny(WALLET_ITEM_CANDIDATES);
            clsWalletDataWrapper = WalletBridge.tryLoadAny(WALLET_WRAPPER_CANDIDATES);
            if (clsWalletHandler == null || clsWalletItem == null || clsWalletDataWrapper == null) {
                Villager_retraining_plus.LOG().info("[VRP] LC wallet classes not found. Candidates tried: {}, {}, {}", new Object[]{WALLET_HANDLER_CANDIDATES, WALLET_ITEM_CANDIDATES, WALLET_WRAPPER_CANDIDATES});
                return;
            }
            mWalletHandler_get = WalletBridge.safeGetMethod(clsWalletHandler, "get", Entity.class);
            mWalletHandler_getWallet = WalletBridge.safeGetMethod(clsWalletHandler, "getWallet", new Class[0]);
            mWalletHandler_setChanged = WalletBridge.safeGetMethod(clsWalletHandler, "setChanged", new Class[0]);
            mWalletItem_isWallet = WalletBridge.safeGetMethod(clsWalletItem, "isWallet", ItemStack.class);
            mWalletItem_getDataWrapper = WalletBridge.safeGetMethod(clsWalletItem, "getDataWrapper", ItemStack.class);
            mWrapper_getContents = WalletBridge.safeGetMethod(clsWalletDataWrapper, "getContents", new Class[0]);
            mWrapper_setContents = WalletBridge.safeGetMethod(clsWalletDataWrapper, "setContents", Container.class, LivingEntity.class);
            if (WalletBridge.areBound()) {
                Villager_retraining_plus.LOG().info("[VRP] LC wallet API bound successfully via reflection.");
            } else {
                Villager_retraining_plus.LOG().info("[VRP] LC wallet API binding incomplete (methods missing). Will fall back if used.");
            }
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] bindReflectionHandles failed: {}", (Object)t.toString());
        }
    }

    private static Class<?> tryLoadAny(List<String> candidates) {
        for (String name : candidates) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static Method safeGetMethod(Class<?> cls, String name, Class<?> ... params) {
        try {
            Method m = cls.getMethod(name, params);
            m.setAccessible(true);
            return m;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private WalletBridge() {
    }
}

