/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import org.z2six.villager_retraining_plus.Config;

public final class RerollState {
    private static final Map<UUID, Long> lastTick = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> dailyCount = new HashMap<UUID, Integer>();
    private static long lastDay = Long.MIN_VALUE;

    public static boolean canReroll(ServerPlayer sp, Villager vill) {
        int used;
        long last;
        int cooldown;
        ServerLevel lvl = sp.serverLevel();
        long now = lvl.getGameTime();
        long day = lvl.getDayTime() / 24000L;
        if (day != lastDay) {
            dailyCount.clear();
            lastDay = day;
        }
        if ((cooldown = Config.cooldownTicks) > 0 && (last = lastTick.getOrDefault(vill.getUUID(), Long.MIN_VALUE).longValue()) != Long.MIN_VALUE && now - last < (long)cooldown) {
            return false;
        }
        int cap = Config.perVillagerDaily;
        return cap <= 0 || (used = dailyCount.getOrDefault(vill.getUUID(), 0).intValue()) < cap;
    }

    public static void markRerolled(ServerPlayer sp, Villager vill) {
        long now = sp.serverLevel().getGameTime();
        UUID id = vill.getUUID();
        lastTick.put(id, now);
        if (Config.perVillagerDaily > 0) {
            dailyCount.merge(id, 1, Integer::sum);
        }
    }
}

