/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;
import org.z2six.villager_retraining_plus.mixin.MerchantMenuAccessor;
import org.z2six.villager_retraining_plus.network.ClientTooltipCache;
import org.z2six.villager_retraining_plus.network.Network;
import org.z2six.villager_retraining_plus.network.PacketRequestReroll;
import org.z2six.villager_retraining_plus.network.PacketTooltipData;
import org.z2six.villager_retraining_plus.network.PacketTooltipQuery;

public final class ClientUI {
    private static final long TOOLTIP_REFRESH_DEBOUNCE_MS = 750L;
    private static final Map<Screen, Button> REROLL_BUTTONS = new WeakHashMap<Screen, Button>();

    public static void registerRuntimeClientEvents() {
        NeoForge.EVENT_BUS.addListener(ClientUI::onScreenInitPost);
        NeoForge.EVENT_BUS.addListener(ClientUI::onScreenRenderPost);
        NeoForge.EVENT_BUS.addListener(ClientUI::onScreenClosed);
        Villager_retraining_plus.LOG().info("[VRP] ClientUI.registerRuntimeClientEvents(): handlers added");
    }

    private static void onScreenInitPost(ScreenEvent.Init.Post e) {
        try {
            Screen screen = e.getScreen();
            if (!(screen instanceof MerchantScreen)) {
                return;
            }
            MerchantScreen screen2 = (MerchantScreen)screen;
            int left = (screen2.width - 276) / 2;
            int top = (screen2.height - 166) / 2;
            int x = left + 276 - 22;
            int y = top + 6;
            int w = 18;
            int h = 18;
            Button reroll = Button.builder((Component)Component.literal((String)"\u21bb"), btn -> {
                try {
                    Network.sendToServer(new PacketRequestReroll());
                }
                catch (Throwable t) {
                    Villager_retraining_plus.LOG().error("[VRP] Client send reroll packet failed", t);
                }
                try {
                    btn.setFocused(false);
                    Screen scr = Minecraft.getInstance().screen;
                    if (scr != null && scr.getFocused() == btn) {
                        scr.setFocused(null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).pos(x, y).size(w, h).createNarration(s -> Component.literal((String)"Retrain Villager")).build();
            e.addListener((GuiEventListener)reroll);
            REROLL_BUTTONS.put((Screen)screen2, reroll);
            Villager_retraining_plus.LOG().info("[VRP] Reroll button added to MerchantScreen at ({},{})", (Object)x, (Object)y);
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] onScreenInitPost exception", t);
        }
    }

    private static void onScreenRenderPost(ScreenEvent.Render.Post e) {
        try {
            Screen screen = e.getScreen();
            if (!(screen instanceof MerchantScreen)) {
                return;
            }
            MerchantScreen screen2 = (MerchantScreen)screen;
            Button btn = REROLL_BUTTONS.get(screen2);
            if (btn == null) {
                return;
            }
            if (btn.isMouseOver((double)e.getMouseX(), (double)e.getMouseY())) {
                List<Component> lines;
                if (ClientTooltipCache.ageMs() > 750L) {
                    ClientUI.trySendTooltipQuery(screen2);
                }
                if ((lines = ClientUI.buildTooltipLines(ClientTooltipCache.get())).isEmpty()) {
                    lines = List.of(Component.literal((String)"Syncing\u2026"));
                }
                GuiGraphics gg = e.getGuiGraphics();
                gg.renderComponentTooltip(Minecraft.getInstance().font, lines, e.getMouseX(), e.getMouseY());
            }
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] onScreenRenderPost exception", t);
        }
    }

    private static void onScreenClosed(ScreenEvent.Closing e) {
        try {
            REROLL_BUTTONS.remove(e.getScreen());
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] onScreenClosed exception", t);
        }
    }

    private static void trySendTooltipQuery(MerchantScreen screen) {
        try {
            AbstractContainerMenu abstractContainerMenu = screen.getMenu();
            if (abstractContainerMenu instanceof MerchantMenu) {
                MerchantMenu menu = (MerchantMenu)abstractContainerMenu;
                Merchant trader = ((MerchantMenuAccessor)menu).vrp$getTrader();
                if (trader instanceof Entity) {
                    Entity ent = (Entity)trader;
                    Network.sendToServer(new PacketTooltipQuery(ent.getId()));
                } else if (trader instanceof AbstractVillager) {
                    AbstractVillager av = (AbstractVillager)trader;
                    Network.sendToServer(new PacketTooltipQuery(av.getId()));
                } else {
                    Network.sendToServer(new PacketTooltipQuery(-1));
                }
            }
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] Client send tooltip query failed", t);
        }
    }

    private static List<Component> buildTooltipLines(PacketTooltipData d) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (d == null) {
            return lines;
        }
        lines.add((Component)Component.literal((String)"Retrain Villager"));
        if (d.cost.scaledCost <= 0 || d.cfg.freeMode) {
            lines.add((Component)Component.literal((String)"Cost: Free"));
        } else {
            String itemName = "Unknown Item";
            try {
                Item item;
                ResourceLocation id = d.cost.item;
                if (id != null && (item = (Item)BuiltInRegistries.ITEM.get(id)) != null) {
                    itemName = new ItemStack((ItemLike)item).getHoverName().getString();
                }
            }
            catch (Throwable id) {
                // empty catch block
            }
            String affordMark = d.afford.canAfford ? "\u2714" : "\u2716";
            String src = switch (d.afford.source == null ? "none" : d.afford.source) {
                case "wallet" -> " (from wallet)";
                case "inventory" -> " (from inventory)";
                case "both" -> " (wallet/inventory)";
                default -> "";
            };
            lines.add((Component)Component.literal((String)("Cost: " + d.cost.scaledCost + " \u00d7 " + itemName + " " + affordMark + src)));
        }
        lines.add((Component)Component.literal((String)("Villager: L" + d.villager.level + " (" + d.villager.xp + " XP)")));
        if (d.cost.nextCostIfUsed != null) {
            lines.add((Component)Component.literal((String)("Next cost: " + d.cost.nextCostIfUsed)));
        }
        if (d.cost.maxCostPossible != null) {
            lines.add((Component)Component.literal((String)("Max cost: " + d.cost.maxCostPossible)));
        }
        if (d.cfg.capEnabled && d.cap.enabled && d.cap.cap > 0) {
            if (d.cap.remaining >= 0) {
                String resetStr = "";
                long now = System.currentTimeMillis();
                if (d.cap.nextResetEpochMs > now) {
                    long delta = d.cap.nextResetEpochMs - now;
                    long s = Math.max(0L, delta / 1000L);
                    long h = s / 3600L;
                    long m = s % 3600L / 60L;
                    long sec = s % 60L;
                    resetStr = String.format(" \u2022 resets in %dh %dm %ds", h, m, sec);
                }
                lines.add((Component)Component.literal((String)("Daily uses: " + d.cap.remaining + " / " + d.cap.cap + resetStr)));
            } else {
                lines.add((Component)Component.literal((String)("Daily uses: \u2014 / " + d.cap.cap)));
            }
        }
        return lines;
    }

    private ClientUI() {
    }
}

