/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.recipe_modification.api.RecipeModifierHolder;
import net.player005.recipe_modification.serialization.ModificationSetSerializer;
import net.player005.recipe_modification.serialization.RecipeFilterSerializer;
import org.slf4j.Logger;

public class RecipeModifierManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public RecipeModifierManager() {
        super(GSON, "recipe_modifier");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                JsonObject json = entry.getValue().getAsJsonObject();
                builder.add((Object)new RecipeModifierHolder(id, RecipeFilterSerializer.fromJson(json.get("target_recipes")), ModificationSetSerializer.fromJson(json.get("modifiers"))));
            }
            catch (Exception exception) {
                LOGGER.error("Error loading recipe modifier {}:", (Object)id, (Object)exception);
            }
        }
        ImmutableList list = builder.build();
        RecipeModification.updateJsonRecipeModifiers((ImmutableList<RecipeModifierHolder>)list);
        LOGGER.info("Loaded {} recipe modifiers", (Object)list.size());
    }
}

