/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.player005.recipe_modification.api.ModificationSet;
import net.player005.recipe_modification.api.Platform;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.api.RecipeModifier;
import net.player005.recipe_modification.api.RecipeModifierHolder;
import net.player005.recipe_modification.api.ResultItemModifier;
import net.player005.recipe_modification.impl.RecipeManagerAccessorTwo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecipeModification {
    public static final String modID = "recipe_modification";
    static final Logger logger = LoggerFactory.getLogger(RecipeModification.class);
    private static Platform platform;
    private static final NonNullList<Consumer<RecipeManager>> recipeManagerCallbacks;
    private static final NonNullList<ResourceLocation> toRemove;
    private static final NonNullList<RecipeModifierHolder> modifiers;
    private static @UnknownNullability ImmutableList<RecipeModifierHolder> modifiersFromDatapack;
    public static final List<ResultItemModifier> resultModifiers;
    private static final Map<Recipe<?>, ItemStack> resultItemOverrides;
    private static @UnknownNullability ImmutableMultimap<Item, RecipeHolder<?>> recipesByResult;
    private static @UnknownNullability RecipeManager recipeManager;

    public static void onRecipeInit(Consumer<RecipeManager> consumer) {
        recipeManagerCallbacks.add(consumer);
    }

    public static CompletableFuture<Void> forAllRecipesAsync(Consumer<RecipeHolder<?>> recipeConsumer) {
        return CompletableFuture.runAsync(() -> recipeManager.getRecipes().forEach(recipeConsumer));
    }

    public static void registerGlobalResultModifier(ResultItemModifier modifier) {
        resultModifiers.add(modifier);
    }

    public static void modifyResultItemSimple(Recipe<?> recipe, Consumer<ItemStack> modifier) {
        ItemStack result = recipe.getResultItem(RecipeModification.getRegistryAccess());
        modifier.accept(result);
        if (recipe.getResultItem(RecipeModification.getRegistryAccess()) == result) {
            return;
        }
        RecipeModification.registerGlobalResultModifier((recipe1, result1, recipeInput) -> {
            if (recipe1 == recipe) {
                modifier.accept(result1);
            }
            return result1;
        });
    }

    public static void replaceResultItem(Recipe<?> recipe, ItemStack newResult) {
        resultItemOverrides.put(recipe, newResult);
    }

    public static @UnknownNullability RecipeHolder<?> findRecipeHolder(Recipe<?> recipe) {
        for (RecipeHolder recipeHolder : RecipeModification.getRecipeManager().getRecipes()) {
            if (!recipeHolder.value().equals(recipe)) continue;
            return recipeHolder;
        }
        return null;
    }

    public static @UnknownNullability ResourceLocation findRecipeID(Recipe<?> recipe) {
        for (RecipeHolder recipeHolder : RecipeModification.getRecipeManager().getRecipes()) {
            if (!recipeHolder.value().equals(recipe)) continue;
            return recipeHolder.id();
        }
        return null;
    }

    public static void removeRecipe(RecipeHolder<?> recipeHolder) {
        toRemove.add((Object)recipeHolder.id());
    }

    public static void removeRecipe(ResourceLocation id) {
        toRemove.add((Object)id);
    }

    public static void registerModifier(RecipeModifierHolder recipeModifier) {
        modifiers.add((Object)recipeModifier);
    }

    public static void registerModifier(ResourceLocation id, RecipeFilter filter, ModificationSet modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static void registerModifier(ResourceLocation id, RecipeFilter filter, RecipeModifier ... modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static RecipeHolder<?> getByID(ResourceLocation id) {
        RecipeModification.checkInitialised("get recipe by ID");
        return RecipeModification.getPlatform().getRecipeByID(recipeManager, id);
    }

    @ApiStatus.Internal
    public static void initPlatform(Platform platform) {
        RecipeModification.platform = platform;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static @UnknownNullability RecipeManager getRecipeManager() {
        return recipeManager;
    }

    public static HolderLookup.Provider getRegistryAccess() {
        RecipeModification.checkInitialised("get the RecipeManager's registry access");
        return RecipeModification.getPlatform().getRegistryAccess(RecipeModification.getRecipeManager());
    }

    public static ImmutableMultimap<Item, RecipeHolder<?>> getRecipesByResult() {
        RecipeModification.checkInitialised("get recipes by result map");
        return recipesByResult;
    }

    public static ImmutableCollection<RecipeHolder<?>> getRecipesByResult(Item resultItem) {
        RecipeModification.checkInitialised("get recipe by result");
        return recipesByResult.get((Object)resultItem);
    }

    public static List<RecipeModifierHolder> getAllModifiers() {
        ArrayList<RecipeModifierHolder> fullList = new ArrayList<RecipeModifierHolder>(modifiers.size() + modifiersFromDatapack.size());
        fullList.addAll((Collection<RecipeModifierHolder>)modifiers);
        fullList.addAll((Collection<RecipeModifierHolder>)modifiersFromDatapack);
        return fullList;
    }

    public static ItemStack tryGetResult(RecipeHolder<?> recipe, HolderLookup.Provider registryAccess) {
        try {
            return recipe.value().getResultItem(registryAccess);
        }
        catch (Exception exception) {
            logger.warn("Failed to get result for recipe {}", (Object)recipe.id());
            logger.debug("Exception querying result:", (Throwable)exception);
            return ItemStack.EMPTY;
        }
    }

    public static boolean isInitialised() {
        return recipeManager != null;
    }

    private static void checkInitialised(String action) {
        if (!RecipeModification.isInitialised()) {
            throw new IllegalStateException("Can't " + action + " before recipes are initialised.Maybe you need to use RecipeModification#onRecipeInit() ?");
        }
    }

    @ApiStatus.Internal
    public static ItemStack getRecipeResult(Recipe<?> recipe, ItemStack currentResult, @Nullable RecipeInput recipeInput) {
        currentResult = resultItemOverrides.getOrDefault(recipe, currentResult).copy();
        for (ResultItemModifier modifier : resultModifiers) {
            currentResult = modifier.getResultItem(recipe, currentResult, recipeInput);
        }
        return currentResult;
    }

    @ApiStatus.Internal
    public static void onRecipeManagerLoad(RecipeManager recipeManager) {
        RecipeModification.recipeManager = recipeManager;
        if (modifiersFromDatapack == null) {
            throw new IllegalStateException("Recipes were loaded before recipe modifiers from datapacks");
        }
        RecipeModification.applyModifications();
    }

    @ApiStatus.Internal
    public static void updateJsonRecipeModifiers(ImmutableList<RecipeModifierHolder> modifiers) {
        modifiersFromDatapack = modifiers;
    }

    @ApiStatus.Internal
    private static void applyModifications() {
        Stopwatch timer = Stopwatch.createStarted();
        CompletableFuture<Void> recipeManagerMutable = CompletableFuture.runAsync(() -> ((RecipeManagerAccessorTwo)recipeManager).recipeModification$makeMutable());
        recipesByResult = RecipeModification.buildRecipeResultMap();
        logger.debug("Built recipe by result map for {} recipes in {}", (Object)recipeManager.getRecipes().size(), (Object)timer);
        timer.reset().start();
        for (Consumer recipeManagerCallback : recipeManagerCallbacks) {
            recipeManagerCallback.accept(recipeManager);
        }
        logger.debug("Executed {} recipe manager callbacks in {}", (Object)recipeManagerCallbacks.size(), (Object)timer);
        timer.reset().start();
        int modified = 0;
        logger.info("Found {} recipe modifiers in datapacks, {} total", (Object)modifiersFromDatapack.size(), (Object)RecipeModification.getAllModifiers().size());
        HolderLookup.Provider registryAccess = RecipeModification.getRegistryAccess();
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            int appliedOnRecipe = RecipeModification.applyAllModifiers(recipeHolder, registryAccess);
            modified += appliedOnRecipe;
        }
        recipeManagerMutable.join();
        recipeManager.getRecipes().removeIf(r -> toRemove.contains((Object)r.id()));
        recipeManager.getOrderedRecipes().removeIf(r -> toRemove.contains((Object)r.id()));
        logger.info("Applied {} modifications to recipes in {}", (Object)modified, (Object)timer);
    }

    private static int applyAllModifiers(RecipeHolder<?> recipeHolder, HolderLookup.Provider registryAccess) {
        int appliedOnRecipe = 0;
        for (RecipeModifierHolder modifier : RecipeModification.getAllModifiers()) {
            try {
                if (!modifier.filter().shouldApply(recipeHolder, registryAccess)) continue;
                RecipeHelper helper = RecipeModification.getPlatform().getHelper();
                modifier.apply(recipeHolder.value(), helper);
            }
            catch (Exception e) {
                RecipeModification.handleError(recipeHolder, modifier, e);
            }
            ++appliedOnRecipe;
        }
        return appliedOnRecipe;
    }

    private static ImmutableMultimap<Item, RecipeHolder<?>> buildRecipeResultMap() {
        ImmutableMultimap.Builder byResultBuilder = ImmutableMultimap.builder();
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            ItemStack result = RecipeModification.tryGetResult(recipeHolder, RecipeModification.getRegistryAccess());
            if (result == null) continue;
            byResultBuilder.put((Object)result.getItem(), (Object)recipeHolder);
        }
        return byResultBuilder.build();
    }

    private static void handleError(RecipeHolder<?> recipe, RecipeModifierHolder modifier, Exception e) {
        logger.debug("Failed to apply modifier '{}' to recipe '{}'", (Object)modifier.id(), (Object)recipe.id());
        logger.debug("Exception:", (Throwable)e);
    }

    static {
        recipeManagerCallbacks = NonNullList.create();
        toRemove = NonNullList.create();
        modifiers = NonNullList.create();
        resultModifiers = NonNullList.create();
        resultItemOverrides = new IdentityHashMap();
    }
}

