/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.config;

import ca.spottedleaf.starlight.common.thread.SchedulingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.neoforged.fml.loading.FMLPaths;

public class Config {
    public static final int PARALLELISM;

    public static void init() {
    }

    private static int getInt(Properties properties, Properties newProperties, String key, int def) {
        try {
            int i = Integer.parseInt(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    static {
        Properties properties = new Properties();
        Properties newProperties = new Properties();
        Path path = FMLPaths.CONFIGDIR.get().resolve("scalablelux.properties");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!SchedulingUtil.isExternallyManaged()) {
            int parallelism = Config.getInt(properties, newProperties, "parallelism", -1);
            if (parallelism < 1) {
                parallelism = Math.max(1, Runtime.getRuntime().availableProcessors() / 3);
            }
            PARALLELISM = parallelism;
        } else {
            PARALLELISM = Math.max(1, Runtime.getRuntime().availableProcessors() / 3);
        }
        if (!newProperties.isEmpty()) {
            try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                newProperties.store(out, "Configuration file for ScalableLux");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

