/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichBossRoom;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerMagicGallery;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerSpawnerBridge;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBridge;

public final class LichTowerSegment
extends TwilightJigsawPiece
implements PieceBeardifierModifier,
SpawnIndexProvider {
    @Autowired
    private static LichTowerUtil lichTowerUtil;
    private final boolean putMobBridge;
    private final boolean putWings;
    private final boolean putGallery;

    public LichTowerSegment(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_TOWER_SEGMENT.get(), compoundTag, ctx, LichTowerSegment.readSettings(compoundTag));
        LichTowerUtil.addDefaultProcessors(this.placeSettings);
        LichTowerSegment.stairDecay(this.genDepth, this.placeSettings);
        this.putMobBridge = compoundTag.getBoolean("put_bridge");
        this.putWings = compoundTag.getBoolean("put_wings");
        this.putGallery = compoundTag.getBoolean("put_gallery");
    }

    public LichTowerSegment(StructureTemplateManager structureManager, int genDepth, JigsawPlaceContext jigsawContext, boolean putMobBridge, boolean putWings, boolean putGallery, ResourceLocation template) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_TOWER_SEGMENT.get(), genDepth, structureManager, template, jigsawContext);
        LichTowerUtil.addDefaultProcessors(this.placeSettings);
        LichTowerSegment.stairDecay(this.genDepth, this.placeSettings);
        this.putMobBridge = putMobBridge;
        this.putWings = putWings;
        this.putGallery = putGallery;
    }

    private static void stairDecay(int depth, StructurePlaceSettings settings) {
        int decayLevel = Mth.ceil((double)((double)(depth - 3) * 0.5));
        if (decayLevel >= 0) {
            StructureProcessor[] stairDecayProcessors = lichTowerUtil.getStairDecayProcessors();
            decayLevel = Math.min(decayLevel, stairDecayProcessors.length);
            settings.addProcessor(stairDecayProcessors[decayLevel]);
        }
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.putBoolean("put_bridge", this.putMobBridge);
        structureTag.putBoolean("put_wings", this.putWings);
        structureTag.putBoolean("put_gallery", this.putGallery);
    }

    public static void buildTowerBySegments(StructurePieceAccessor pieceAccessor, RandomSource random, BlockPos sourceJigsawPos, FrontAndTop sourceOrientation, TwilightJigsawPiece parentBase, StructureTemplateManager structureManager, int segments) {
        JigsawPlaceContext bossRoomJunction;
        ResourceLocation segmentId = TwilightForestMod.prefix("lich_tower/tower_slice");
        ArrayList<LichTowerSegment> pieces = new ArrayList<LichTowerSegment>();
        TwilightTemplateStructurePiece priorPiece = parentBase;
        BlockPos priorJigsawOffset = sourceJigsawPos;
        FrontAndTop priorOrientation = sourceOrientation;
        int mobBridge = random.nextIntBetweenInclusive(0, 5);
        for (int stackIndex = 0; stackIndex < segments; ++stackIndex) {
            JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(priorPiece.templatePosition(), priorJigsawOffset, priorOrientation, structureManager, segmentId, "twilightforest:lich_tower/tower_below", random);
            if (placeableJunction == null) continue;
            boolean bl = stackIndex > segments >> 1;
            boolean putGallery = stackIndex == segments - 1;
            LichTowerSegment towerSegment = new LichTowerSegment(structureManager, priorPiece.getGenDepth() + 1, placeableJunction, mobBridge == 0, bl, putGallery, TwilightForestMod.prefix("lich_tower/tower_slice"));
            pieceAccessor.addPiece((StructurePiece)towerSegment);
            pieces.add(towerSegment);
            JigsawRecord firstJunction = placeableJunction.findFirst("twilightforest:lich_tower/tower_above");
            if (firstJunction == null) break;
            priorPiece = towerSegment;
            priorJigsawOffset = firstJunction.pos();
            priorOrientation = firstJunction.orientation();
            mobBridge = mobBridge == 0 ? random.nextIntBetweenInclusive(2, 5) : mobBridge - 1;
        }
        if ((bossRoomJunction = JigsawPlaceContext.pickPlaceableJunction(priorPiece.templatePosition(), priorJigsawOffset, priorOrientation, structureManager, TwilightForestMod.prefix("lich_tower/tower_boss_room"), "twilightforest:lich_tower/tower_below", random)) != null) {
            LichBossRoom bossRoom = new LichBossRoom(structureManager, bossRoomJunction);
            pieceAccessor.addPiece((StructurePiece)bossRoom);
            bossRoom.addChildren((StructurePiece)priorPiece, pieceAccessor, random);
            LichTowerSegment lichTowerSegment = new LichTowerSegment(structureManager, priorPiece.getGenDepth() + 1, bossRoomJunction.copy(), false, false, false, TwilightForestMod.prefix("lich_tower/tower_boss_boundary"));
            pieceAccessor.addPiece((StructurePiece)lichTowerSegment);
            lichTowerSegment.addChildren((StructurePiece)priorPiece, pieceAccessor, random);
        }
        if (pieces.isEmpty()) {
            return;
        }
        priorPiece = (TwilightTemplateStructurePiece)((Object)pieces.removeLast());
        priorPiece.addChildren((StructurePiece)(pieces.isEmpty() ? parentBase : (StructurePiece)pieces.getLast()), pieceAccessor, random);
        priorPiece = parentBase;
        for (TwilightTemplateStructurePiece twilightTemplateStructurePiece : pieces) {
            twilightTemplateStructurePiece.addChildren((StructurePiece)priorPiece, pieceAccessor, random);
            priorPiece = twilightTemplateStructurePiece;
        }
    }

    @Override
    protected void processJigsaw(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, int jigsawIndex) {
        switch (connection.target()) {
            case "twilightforest:lich_tower/bridge": {
                if (!this.putWings) {
                    return;
                }
                if (this.putGallery) {
                    if (jigsawIndex != 2 || random.nextInt(10) != 0) break;
                    LichTowerMagicGallery.tryPlaceGallery(random, pieceAccessor, lichTowerUtil.rollTowerGallery(random), connection, this, this.genDepth + 1, this.structureManager, "twilightforest:lich_tower/bridge_center");
                    break;
                }
                LichTowerWingBridge.tryRoomAndBridge(this, pieceAccessor, random, connection, this.structureManager, true, 4, false, this.genDepth + 1, null);
                break;
            }
            case "twilightforest:mob_bridge": {
                if (!this.putMobBridge) break;
                FrontAndTop orientation = connection.orientation();
                FrontAndTop forPlacement = random.nextBoolean() ? orientation : FrontAndTop.fromFrontAndTop((Direction)orientation.front(), (Direction)orientation.top().getOpposite());
                ResourceLocation mobBridgeLocation = lichTowerUtil.rollRandomMobBridge(random);
                JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(this.templatePosition(), connection.pos(), forPlacement, this.structureManager, mobBridgeLocation, "twilightforest:mob_bridge", random);
                if (placeableJunction == null) break;
                LichTowerSpawnerBridge mobBridgePiece = new LichTowerSpawnerBridge(this.genDepth + 1, this.structureManager, mobBridgeLocation, placeableJunction, random.nextBoolean());
                pieceAccessor.addPiece((StructurePiece)mobBridgePiece);
                mobBridgePiece.addChildren((StructurePiece)this, pieceAccessor, random);
            }
        }
    }

    @Override
    protected void handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen) {
        LichBossRoom.placePainting(label, pos, (ServerLevelAccessor)level, random, chunkBounds, this.placeSettings.getRotation(), 2, 10, CustomTagGenerator.PaintingVariantTagGenerator.LICH_TOWER_PAINTINGS);
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.NONE;
    }

    @Override
    public int getGroundLevelDelta() {
        return 0;
    }

    @Override
    public int getSpawnIndex() {
        return 1;
    }
}

