/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.hollowtree;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.logging.log4j.Logger;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.hollowtree.HollowTreePiece;

public class HollowTreeLeafDungeon
extends HollowTreePiece {
    private final int radius;
    private final BlockStateProvider wood;
    private final BlockStateProvider leaves;
    private final BlockStateProvider inside;
    private final BlockStateProvider lootContainer;
    private final ResourceKey<LootTable> lootTable;
    private final Holder<EntityType<?>> monster;

    protected HollowTreeLeafDungeon(int index, int x, int y, int z, int radius, BlockStateProvider wood, BlockStateProvider leaves, BlockStateProvider inside, BlockStateProvider lootContainer, ResourceKey<LootTable> lootTable, Holder<EntityType<?>> monster, RandomSource random) {
        super((StructurePieceType)TFStructurePieceTypes.TFHTLD.value(), index, new BoundingBox(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
        this.setOrientation(StructurePiece.getRandomHorizontalDirection((RandomSource)random));
        this.radius = radius;
        this.wood = wood;
        this.leaves = leaves;
        this.inside = inside;
        this.lootContainer = lootContainer;
        this.lootTable = lootTable;
        this.monster = monster;
    }

    public HollowTreeLeafDungeon(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)TFStructurePieceTypes.TFHTLD.value(), tag);
        this.radius = tag.getInt("leafRadius");
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess());
        this.wood = BlockStateProvider.CODEC.parse((DynamicOps)ops, (Object)tag.getCompound("wood")).result().orElse(HollowTreePiece.DEFAULT_WOOD);
        this.leaves = BlockStateProvider.CODEC.parse((DynamicOps)ops, (Object)tag.getCompound("leaves")).result().orElse(HollowTreePiece.DEFAULT_LEAVES);
        this.inside = BlockStateProvider.CODEC.parse((DynamicOps)ops, (Object)tag.getCompound("air")).result().orElse(HollowTreePiece.DEFAULT_DUNGEON_AIR);
        this.lootContainer = BlockStateProvider.CODEC.parse((DynamicOps)ops, (Object)tag.getCompound("loot_block")).result().orElse(HollowTreePiece.DEFAULT_DUNGEON_LOOT_BLOCK);
        this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("loot_table")));
        ResourceKey dungeonMonster = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("monster")));
        this.monster = context.registryAccess().registry(Registries.ENTITY_TYPE).flatMap(reg -> reg.getHolder(dungeonMonster)).orElse(HollowTreePiece.DEFAULT_DUNGEON_MONSTER);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.putInt("leafRadius", this.radius);
        tag.put("wood", BlockStateProvider.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.wood).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElseGet(CompoundTag::new));
        tag.put("leaves", BlockStateProvider.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.leaves).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElseGet(CompoundTag::new));
        tag.put("air", BlockStateProvider.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.inside).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElseGet(CompoundTag::new));
        tag.put("loot_block", BlockStateProvider.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.lootContainer).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElseGet(CompoundTag::new));
        tag.putString("loot_table", this.lootTable.location().toString());
        tag.putString("monster", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)this.monster.value())).toString());
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource doNotUse, BoundingBox writeableBounds, ChunkPos chunkPos, BlockPos structureBottomCenter) {
        XoroshiroRandomSource decoRNG = this.getInterChunkDecoRNG(level);
        this.drawBlockBlob(level, writeableBounds, this.radius, this.radius, this.radius, 5, (RandomSource)decoRNG, this.leaves, false, true, true);
        this.drawBlockBlob(level, writeableBounds, this.radius, this.radius, this.radius, 3, (RandomSource)decoRNG, this.wood, false, false, false);
        this.drawBlockBlob(level, writeableBounds, this.radius, this.radius, this.radius, 2, (RandomSource)decoRNG, this.inside, true, false, true);
        this.placeTreasureAtCurrentPosition(level, this.radius, this.radius - 1, this.radius, writeableBounds, (RandomSource)decoRNG, this.lootContainer, this.lootTable);
        this.placeSpawnerAtCurrentPosition(level, (RandomSource)decoRNG, this.radius, this.radius, this.radius, (EntityType<? extends Entity>)((EntityType)this.monster.value()), writeableBounds);
    }

    protected void placeTreasureAtCurrentPosition(WorldGenLevel world, int x, int y, int z, BoundingBox sbb, RandomSource random, BlockStateProvider stateProvider, ResourceKey<LootTable> lootTable) {
        Direction direction = (new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST})[random.nextInt(4)];
        BlockPos pos = this.getWorldPos(x, y, z).relative(direction, 2);
        BlockState state = stateProvider.getState(random, pos).mirror(this.mirror).rotate((LevelAccessor)world, pos, this.rotation);
        if (state.getBlock() instanceof ChestBlock) {
            state = (BlockState)state.setValue((Property)ChestBlock.FACING, (Comparable)direction.getOpposite());
        }
        if (sbb.isInside((Vec3i)pos) && !world.getBlockState(pos).is(state.getBlock())) {
            world.setBlock(pos, state, 2);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity randomLootContainer = (RandomizableContainerBlockEntity)blockEntity;
                randomLootContainer.setLootTable(lootTable, random.nextLong());
            }
        }
    }

    protected void placeSpawnerAtCurrentPosition(WorldGenLevel world, RandomSource rand, int x, int y, int z, EntityType<? extends Entity> monsterID, BoundingBox sbb) {
        BlockPos.MutableBlockPos pos = this.getWorldPos(x, y, z);
        if (sbb.isInside((Vec3i)pos) && !world.getBlockState((BlockPos)pos).is(Blocks.SPAWNER)) {
            world.setBlock((BlockPos)pos, Blocks.SPAWNER.defaultBlockState(), 2);
            BlockEntity blockEntity = world.getBlockEntity((BlockPos)pos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                spawner.setEntityId(monsterID, rand);
            }
        }
    }
}

