/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFFeatureModifiers;

public class TrunkSideDecorator
extends TreeDecorator {
    public static final MapCodec<TrunkSideDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)64).fieldOf("placement_count").forGetter(o -> o.count), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_of_placement").forGetter(o -> Float.valueOf(o.probability)), (App)BlockStateProvider.CODEC.fieldOf("deco_provider").forGetter(o -> o.decoration)).apply((Applicative)instance, TrunkSideDecorator::new));
    private final int count;
    private final float probability;
    private final BlockStateProvider decoration;

    public TrunkSideDecorator(int count, float probability, BlockStateProvider decorator) {
        this.count = count;
        this.probability = probability;
        this.decoration = decorator;
    }

    protected TreeDecoratorType<TrunkSideDecorator> type() {
        return (TreeDecoratorType)TFFeatureModifiers.TRUNKSIDE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        int blockCount = context.logs().size();
        if (blockCount == 0) {
            TwilightForestMod.LOGGER.error("[TrunkSideDecorator] Trunk Blocks were empty! Why?");
            return;
        }
        for (int attempt = 0; attempt < this.count; ++attempt) {
            Direction direction;
            BlockPos logPos;
            BlockPos newPos;
            if (context.random().nextFloat() >= this.probability || !context.isAir(newPos = (logPos = (BlockPos)context.logs().get(context.random().nextInt(blockCount))).offset((direction = Direction.Plane.HORIZONTAL.getRandomDirection(context.random())).getStepX(), 0, direction.getStepZ()))) continue;
            if (this.decoration.getState(context.random(), newPos).hasProperty((Property)BlockStateProperties.FACING)) {
                context.setBlock(newPos, (BlockState)this.decoration.getState(context.random(), newPos).setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
                continue;
            }
            context.setBlock(newPos, this.decoration.getState(context.random(), newPos));
        }
    }
}

