/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

public class TFCavesCarver
extends WorldCarver<CaveCarverConfiguration> {
    private final boolean isHighlands;
    private final BlockStateProvider wallBlocks;
    private final ImprovedNoise noise;

    public TFCavesCarver(Codec<CaveCarverConfiguration> codec, boolean isHighlands, BlockStateProvider wallBlocks) {
        super(codec);
        this.wallBlocks = wallBlocks;
        this.liquids = ImmutableSet.of((Object)Fluids.WATER, (Object)Fluids.LAVA);
        this.isHighlands = isHighlands;
        this.noise = new ImprovedNoise((RandomSource)new LegacyRandomSource(6972119253061020355L));
    }

    public boolean isStartChunk(CaveCarverConfiguration config, RandomSource rand) {
        return this.isHighlands || rand.nextFloat() <= config.probability;
    }

    public boolean carve(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, RandomSource random, Aquifer aquifer, ChunkPos accessPos, CarvingMask mask) {
        if (this.isHighlands && (Mth.clamp((int)LegacyLandmarkPlacements.manhattanDistanceFromLandmarkCenter(accessPos.x, accessPos.z), (int)0, (int)3) & 1) == 1) {
            return false;
        }
        int i = SectionPos.sectionToBlockCoord((int)(this.getRange() * 2 - 1));
        int caveCount = this.isHighlands ? random.nextInt(2) : random.nextInt(this.getCaveBound());
        for (int caveIndex = 0; caveIndex < caveCount; ++caveIndex) {
            double x = accessPos.getBlockX(random.nextInt(16));
            double y = config.y.sample(random, (WorldGenerationContext)ctx);
            double z = accessPos.getBlockZ(random.nextInt(16));
            double horiz = config.horizontalRadiusMultiplier.sample(random);
            double vert = config.verticalRadiusMultiplier.sample(random);
            double floor = config.floorLevel.sample(random);
            WorldCarver.CarveSkipChecker checker = (context, dX, dY, dZ, yPos) -> TFCavesCarver.shouldSkip(dX, dY, dZ, floor);
            int tunnelCount = 1;
            if (this.isHighlands || random.nextInt(4) == 0) {
                double horizToVertRatio = config.yScale.sample(random);
                float radius = 1.0f + random.nextFloat() * 6.0f;
                this.createRoom(ctx, config, access, biomePos, aquifer, x, y, z, radius, horizToVertRatio, mask, checker);
                tunnelCount += random.nextInt(4);
            }
            for (int tunnelIndex = 0; tunnelIndex < tunnelCount; ++tunnelIndex) {
                float randomRadian = random.nextFloat() * ((float)Math.PI * 2);
                float randomPitch = (random.nextFloat() - 0.5f) / 4.0f;
                float thickness = this.getThickness(random);
                int branchCount = i - random.nextInt(i / 4);
                this.createTunnel(ctx, config, access, biomePos, random.nextLong(), aquifer, x, y, z, horiz, vert, thickness, randomRadian, randomPitch, 0, branchCount, this.getYScale(), mask, checker);
            }
        }
        return true;
    }

    protected boolean carveBlock(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, CarvingMask mask, BlockPos.MutableBlockPos posMutable, BlockPos.MutableBlockPos posUp, Aquifer aquifer, MutableBoolean isSurface) {
        BlockPos pos = posMutable.immutable();
        BlockState stateBeforeReplacement = access.getBlockState(pos);
        if (stateBeforeReplacement.is(Blocks.GRASS_BLOCK) || stateBeforeReplacement.is(Blocks.MYCELIUM) || stateBeforeReplacement.is(Blocks.PODZOL) || stateBeforeReplacement.is(Blocks.DIRT_PATH)) {
            isSurface.setTrue();
        }
        if (pos.getY() < access.getMinBuildHeight() + 6) {
            return false;
        }
        if (!this.canReplaceBlock(config, stateBeforeReplacement) && !TFCavesCarver.isDebugEnabled((CarverConfiguration)config)) {
            return false;
        }
        BlockPos chunkOrigin = access.getPos().getWorldPosition();
        for (Direction facing : Direction.values()) {
            BlockPos relative = pos.relative(facing);
            if (!TFCavesCarver.isInsideChunk(relative, chunkOrigin) || !access.getFluidState(relative).is(FluidTags.WATER)) continue;
            return false;
        }
        BlockState blockStateToPlace = this.getCarveState(ctx, config, pos, aquifer);
        if (blockStateToPlace != null) {
            BlockPos posDown;
            boolean blockPlaced;
            RandomSource randomFromPos = ctx.randomState().oreRandom().at(pos);
            if (!access.getFluidState(pos.above(2)).isEmpty()) {
                blockStateToPlace = randomFromPos.nextBoolean() ? Blocks.ROOTED_DIRT.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState();
            }
            boolean bl = blockPlaced = access.setBlockState(pos, blockStateToPlace, false) != null;
            if (aquifer.shouldScheduleFluidUpdate() && !blockStateToPlace.getFluidState().isEmpty()) {
                access.markPosForPostprocessing(pos);
            }
            if (isSurface.isTrue() && access.getBlockState(posDown = pos.relative(Direction.DOWN)).is(Blocks.DIRT)) {
                ctx.topMaterial(biomePos, access, posDown, !blockStateToPlace.getFluidState().isEmpty()).ifPresent(state -> {
                    access.setBlockState(posDown, state, false);
                    if (!state.getFluidState().isEmpty()) {
                        access.markPosForPostprocessing(posDown);
                    }
                });
            }
            if (blockPlaced) {
                this.postCarveBlock(access, pos, config, randomFromPos, chunkOrigin);
            }
            return blockPlaced;
        }
        return false;
    }

    private static boolean isInsideChunk(BlockPos relative, BlockPos chunkOrigin) {
        int deltaX = relative.getX() - chunkOrigin.getX();
        int deltaZ = relative.getZ() - chunkOrigin.getZ();
        return deltaX >= 0 && deltaZ >= 0 && deltaX <= 15 && deltaZ <= 15;
    }

    private void postCarveBlock(ChunkAccess access, BlockPos pos, CaveCarverConfiguration config, RandomSource rand, BlockPos chunkOrigin) {
        for (Direction facing : Direction.values()) {
            BlockState neighboringBlock;
            BlockPos directionalRelative = pos.relative(facing);
            if (!TFCavesCarver.isInsideChunk(directionalRelative, chunkOrigin)) continue;
            if (this.isHighlands) {
                if (rand.nextInt(4) != 0 || !this.canReplaceBlock(config, access.getBlockState(directionalRelative))) continue;
                access.setBlockState(directionalRelative, this.wallBlocks.getState(rand, directionalRelative), false);
                continue;
            }
            if (facing == Direction.DOWN || facing != Direction.UP && !access.getBlockState(directionalRelative.above()).isAir() && !this.checkNoiseThreshold(directionalRelative, 0.25, 0.5) || !(neighboringBlock = access.getBlockState(directionalRelative)).is(BlockTags.BASE_STONE_OVERWORLD) && !neighboringBlock.getFluidState().is(FluidTags.WATER)) continue;
            access.setBlockState(directionalRelative, this.wallBlocks.getState(rand, directionalRelative), false);
        }
    }

    private boolean checkNoiseThreshold(BlockPos pos, double posScalar, double threshold) {
        double noise = this.noise.noise((double)pos.getX() * posScalar, (double)pos.getY() * posScalar, (double)pos.getZ() * posScalar);
        return noise * 0.5 + 0.5 > threshold;
    }

    protected int getCaveBound() {
        return 4;
    }

    protected float getThickness(RandomSource rand) {
        float f = rand.nextFloat() * 2.0f + rand.nextFloat();
        if (rand.nextInt(10) == 0) {
            f *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getYScale() {
        return 1.0;
    }

    protected void createRoom(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, Aquifer aquifer, double posX, double posY, double posZ, float radius, double horizToVertRatio, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        double d0 = 1.5 + (double)(Mth.sin((float)1.5707964f) * radius);
        double d1 = d0 * horizToVertRatio;
        this.carveEllipsoid(ctx, (CarverConfiguration)config, access, biomePos, aquifer, posX, posY, posZ, d0, d1, mask, checker);
    }

    protected void createTunnel(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, long seed, Aquifer aquifer, double posX, double posY, double posZ, double horizMult, double vertMult, float thickness, float yaw, float pitch, int branchIndex, int branchCount, double horizToVertRatio, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        RandomSource random = RandomSource.create((long)seed);
        int i = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean flag = random.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        for (int j = branchIndex; j < branchCount; ++j) {
            double horizontalRadius = 1.5 + (double)(Mth.sin((float)((float)Math.PI * (float)j / (float)branchCount)) * thickness);
            double verticalRadius = horizontalRadius * horizToVertRatio;
            float f2 = Mth.cos((float)pitch);
            posX += (double)(Mth.cos((float)yaw) * f2);
            float yShift = Mth.sin((float)pitch);
            posY += yShift > 0.0f || posY + (double)yShift > (double)(access.getMinBuildHeight() + 10) ? (double)yShift : (double)(yShift * 0.25f);
            posZ += (double)(Mth.sin((float)yaw) * f2);
            pitch *= flag ? 0.92f : 0.7f;
            pitch += f1 * 0.1f;
            yaw += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && thickness > 1.0f) {
                this.createTunnel(ctx, config, access, biomePos, random.nextLong(), aquifer, posX, posY, posZ, horizMult, vertMult, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, checker);
                this.createTunnel(ctx, config, access, biomePos, random.nextLong(), aquifer, posX, posY, posZ, horizMult, vertMult, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, checker);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!TFCavesCarver.canReach((ChunkPos)access.getPos(), (double)posX, (double)posZ, (int)j, (int)branchCount, (float)thickness)) {
                return;
            }
            boolean shouldEnlargeSphere = posY > (double)(access.getMinBuildHeight() + 12) && random.nextInt(48) == 0;
            float sizeMultiplier = shouldEnlargeSphere ? random.nextFloat() * random.nextFloat() * 2.0f + 1.0f : 1.0f;
            double sphereHRadius = Math.min(horizontalRadius * horizMult * (double)sizeMultiplier, 10.0);
            double sphereVRadius = verticalRadius * vertMult * (double)sizeMultiplier;
            double sphereVRadiusLimited = shouldEnlargeSphere ? Math.min(sphereVRadius, sphereHRadius * (double)0.65f) : sphereVRadius;
            this.carveEllipsoid(ctx, (CarverConfiguration)config, access, biomePos, aquifer, posX, posY, posZ, sphereHRadius, sphereVRadiusLimited, mask, checker);
        }
    }

    protected boolean canReplaceBlock(CaveCarverConfiguration config, BlockState state) {
        return !state.is(BlockTags.ICE) && !state.getFluidState().is(FluidTags.WATER) && super.canReplaceBlock((CarverConfiguration)config, state);
    }

    private static boolean shouldSkip(double posX, double posY, double posZ, double minY) {
        if (posY <= minY) {
            return true;
        }
        return posX * posX + posY * posY + posZ * posZ >= 1.0;
    }

    @Nullable
    public BlockState getCarveState(CarvingContext context, CaveCarverConfiguration config, BlockPos pos, Aquifer aquifer) {
        return Blocks.CAVE_AIR.defaultBlockState();
    }
}

