/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFItems;

public class TFTrimMaterials {
    public static final ResourceKey<TrimMaterial> IRONWOOD = TFTrimMaterials.registerKey("ironwood");
    public static final ResourceKey<TrimMaterial> STEELEAF = TFTrimMaterials.registerKey("steeleaf");
    public static final ResourceKey<TrimMaterial> KNIGHTMETAL = TFTrimMaterials.registerKey("knightmetal");
    public static final ResourceKey<TrimMaterial> FIERY = TFTrimMaterials.registerKey("fiery");
    public static final ResourceKey<TrimMaterial> NAGA_SCALE = TFTrimMaterials.registerKey("naga_scale");
    public static final ResourceKey<TrimMaterial> CARMINITE = TFTrimMaterials.registerKey("carminite");

    private static ResourceKey<TrimMaterial> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        TFTrimMaterials.register(context, IRONWOOD, TFItems.IRONWOOD_INGOT, Style.EMPTY.withColor(0x6B6161), 0.2f);
        TFTrimMaterials.register(context, STEELEAF, TFItems.STEELEAF_INGOT, Style.EMPTY.withColor(4814643), 0.7f);
        TFTrimMaterials.register(context, KNIGHTMETAL, TFItems.KNIGHTMETAL_INGOT, Style.EMPTY.withColor(8424562), 0.1f);
        TFTrimMaterials.register(context, FIERY, TFItems.FIERY_INGOT, Style.EMPTY.withColor(16758076), 0.3f);
        TFTrimMaterials.register(context, NAGA_SCALE, TFItems.NAGA_SCALE, Style.EMPTY.withColor(2381586), 0.7f);
        TFTrimMaterials.register(context, CARMINITE, TFItems.CARMINITE, Style.EMPTY.withColor(0x9A0000), 0.4f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> trimKey, Holder<Item> trimItem, Style color, float itemModelIndex) {
        TrimMaterial material = new TrimMaterial(trimKey.location().getPath(), trimItem, itemModelIndex, Map.of(), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)trimKey.location())).withStyle(color));
        context.register(trimKey, (Object)material);
    }
}

