/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFItems;
import twilightforest.item.MazebreakerPickItem;
import twilightforest.item.MinotaurAxeItem;

@EventBusSubscriber(modid="twilightforest")
public class ToolEvents {
    private static final int KNIGHTMETAL_BONUS_DAMAGE = 2;
    private static final int MINOTAUR_AXE_BONUS_DAMAGE = 7;

    @SubscribeEvent
    public static void onEnderBowHit(ProjectileImpactEvent evt) {
        Projectile arrow = evt.getProjectile();
        Entity entity = arrow.getOwner();
        if (entity instanceof Player) {
            EntityHitResult result;
            Player player = (Player)entity;
            entity = evt.getRayTraceResult();
            if (entity instanceof EntityHitResult && (entity = (result = (EntityHitResult)entity).getEntity()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (arrow.getOwner() != result.getEntity() && !result.getEntity().getType().is(Tags.EntityTypes.BOSSES) && arrow.getPersistentData().contains("twilightforest:ender")) {
                    double sourceX = player.getX();
                    double sourceY = player.getY();
                    double sourceZ = player.getZ();
                    float sourceYaw = player.getYRot();
                    float sourcePitch = player.getXRot();
                    @Nullable Entity playerVehicle = player.getVehicle();
                    player.setYRot(living.getYRot());
                    player.teleportTo(living.getX(), living.getY(), living.getZ());
                    player.invulnerableTime = 40;
                    player.level().broadcastEntityEvent((Entity)player, (byte)46);
                    if (living.isPassenger() && living.getVehicle() != null) {
                        player.startRiding(living.getVehicle(), true);
                        living.stopRiding();
                    }
                    player.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
                    living.setYRot(sourceYaw);
                    living.setXRot(sourcePitch);
                    living.teleportTo(sourceX, sourceY, sourceZ);
                    living.level().broadcastEntityEvent((Entity)player, (byte)46);
                    if (playerVehicle != null) {
                        living.startRiding(playerVehicle, true);
                        player.stopRiding();
                    }
                    living.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void fieryToolSetFire(LivingIncomingDamageEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && ((living = (LivingEntity)entity).getMainHandItem().is((Item)TFItems.FIERY_SWORD.get()) || living.getMainHandItem().is((Item)TFItems.FIERY_PICKAXE.get())) && !event.getEntity().fireImmune()) {
            event.getEntity().igniteForSeconds(1.0f);
        }
    }

    @SubscribeEvent
    public static void onKnightmetalToolDamage(LivingDamageEvent.Pre event) {
        LivingEntity living;
        ItemStack weapon;
        Entity entity;
        LivingEntity target = event.getEntity();
        DamageContainer container = event.getContainer();
        if (!target.level().isClientSide() && (entity = container.getSource().getDirectEntity()) instanceof LivingEntity && !(weapon = (living = (LivingEntity)entity).getMainHandItem()).isEmpty()) {
            if (target.getArmorValue() > 0 && (weapon.is((Item)TFItems.KNIGHTMETAL_PICKAXE.get()) || weapon.is((Item)TFItems.KNIGHTMETAL_SWORD.get()))) {
                if (target.getArmorCoverPercentage() > 0.0f) {
                    int moreBonus = (int)(2.0f * target.getArmorCoverPercentage());
                    container.setNewDamage(container.getOriginalDamage() + (float)moreBonus);
                } else {
                    container.setNewDamage(container.getOriginalDamage() + 2.0f);
                }
                ((ServerLevel)target.level()).getChunkSource().broadcastAndSend((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
            } else if (target.getArmorValue() == 0 && weapon.is((Item)TFItems.KNIGHTMETAL_AXE.get())) {
                container.setNewDamage(container.getOriginalDamage() + 2.0f);
                ((ServerLevel)target.level()).getChunkSource().broadcastAndSend((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
            }
        }
    }

    @SubscribeEvent
    public static void onMinotaurAxeCharge(LivingDamageEvent.Pre event) {
        ItemStack weapon;
        LivingEntity living;
        Entity entity;
        LivingEntity target = event.getEntity();
        DamageContainer container = event.getContainer();
        if (!target.level().isClientSide() && (entity = container.getSource().getDirectEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).isSprinting() && (container.getSource().getMsgId().equals("player") || container.getSource().getMsgId().equals("mob")) && !(weapon = living.getMainHandItem()).isEmpty() && weapon.getItem() instanceof MinotaurAxeItem) {
            container.setNewDamage(container.getOriginalDamage() + 7.0f);
            ((ServerLevel)target.level()).getChunkSource().broadcastAndSend((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
        }
    }

    @SubscribeEvent
    public static void damageToolsExtra(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().getMainHandItem();
        if ((event.getState().is(BlockTagGenerator.MAZESTONE) || event.getState().is(BlockTagGenerator.CASTLE_BLOCKS)) && stack.isDamageableItem() && !(stack.getItem() instanceof MazebreakerPickItem)) {
            stack.hurtAndBreak(16, (LivingEntity)event.getPlayer(), EquipmentSlot.MAINHAND);
        }
    }

    @SubscribeEvent
    public static void onMobEffectApplicableEvent(MobEffectEvent.Applicable event) {
        if (event.getApplicationResult() && event.getEffectInstance().is(MobEffects.DIG_SLOWDOWN) && event.getEntity().isHolding((Item)TFItems.POCKET_WATCH.get())) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }
}

