/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFItems;

public class ThrownWep
extends TFThrowable {
    private static final EntityDataAccessor<ItemStack> DATA_ITEMSTACK = SynchedEntityData.defineId(ThrownWep.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> DATA_VELOCITY = SynchedEntityData.defineId(ThrownWep.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float projectileDamage = 6.0f;

    public ThrownWep(EntityType<? extends ThrownWep> type, Level world, LivingEntity thrower) {
        super(type, world, thrower);
    }

    public ThrownWep(EntityType<? extends ThrownWep> type, Level world) {
        super(type, world);
    }

    public ThrownWep setDamage(float damage) {
        this.projectileDamage = damage;
        return this;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEMSTACK, (Object)ItemStack.EMPTY);
        builder.define(DATA_VELOCITY, (Object)Float.valueOf(0.001f));
    }

    public ThrownWep setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEMSTACK, (Object)stack);
        return this;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEMSTACK);
    }

    public ThrownWep setVelocity(float velocity) {
        this.getEntityData().set(DATA_VELOCITY, (Object)Float.valueOf(velocity));
        return this;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (result.getEntity() instanceof KnightPhantom || result.getEntity() == this.getOwner()) {
            return;
        }
        if (!this.level().isClientSide()) {
            result.getEntity().hurt(TFDamageTypes.getDamageSource(this.level(), this.getItem().getItem() == TFItems.KNIGHTMETAL_PICKAXE.get() ? TFDamageTypes.THROWN_PICKAXE : TFDamageTypes.THROWN_AXE, new EntityType[0]), this.projectileDamage);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    protected double getDefaultGravity() {
        return ((Float)this.getEntityData().get(DATA_VELOCITY)).floatValue();
    }
}

