/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.entity.monster.CarminiteGhastguard;

public class GhastguardRandomFlyGoal
extends Goal {
    private final CarminiteGhastguard parentEntity;

    public GhastguardRandomFlyGoal(CarminiteGhastguard ghast) {
        this.parentEntity = ghast;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        MoveControl entitymovehelper = this.parentEntity.getMoveControl();
        if (!entitymovehelper.hasWanted()) {
            return this.parentEntity.getTarget() == null;
        }
        double d0 = entitymovehelper.getWantedX() - this.parentEntity.getX();
        double d1 = entitymovehelper.getWantedY() - this.parentEntity.getY();
        double d2 = entitymovehelper.getWantedZ() - this.parentEntity.getZ();
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.parentEntity.getTarget() == null && (d3 < 1.0 || d3 > 3600.0);
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        RandomSource random = this.parentEntity.getRandom();
        double d0 = this.parentEntity.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.getWanderFactor());
        double d1 = this.parentEntity.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.getWanderFactor());
        double d2 = this.parentEntity.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.getWanderFactor());
        this.parentEntity.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
    }
}

