/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.structures.lichtowerrevamp.StructureTemplateDefinition;

public abstract class StructureTemplateDefinitionProvider
extends JsonCodecProvider<StructureTemplateDefinition> {
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> poolsForTemplateWeights = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public StructureTemplateDefinitionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        super(output, PackOutput.Target.DATA_PACK, "twilight/template_definition", PackType.SERVER_DATA, StructureTemplateDefinition.CODEC, lookupProvider, modId, existingFileHelper);
    }

    protected abstract void generatePools();

    protected void gather() {
        this.generatePools();
        for (Map.Entry<ResourceLocation, Map<ResourceLocation, Integer>> poolWeightsForTemplate : this.poolsForTemplateWeights.entrySet()) {
            ResourceLocation templateId = poolWeightsForTemplate.getKey();
            this.unconditional(templateId, new StructureTemplateDefinition(poolWeightsForTemplate.getValue()));
        }
    }

    protected void addToAllPools(String roomId, int weight, ResourceLocation ... poolIds) {
        for (ResourceLocation poolId : poolIds) {
            this.add(roomId, poolId, weight);
        }
    }

    protected void addAllTemplatesToPool(ResourceLocation poolId, int weight, String ... roomIds) {
        for (String roomId : roomIds) {
            this.add(roomId, poolId, weight);
        }
    }

    protected void add(String roomId, ResourceLocation poolId, int weight) {
        this.add(TwilightForestMod.prefix(roomId), poolId, weight);
    }

    protected void add(ResourceLocation templateId, ResourceLocation poolId, int weight) {
        Map poolWeightsForTemplate = this.poolsForTemplateWeights.computeIfAbsent(templateId, k -> new HashMap());
        poolWeightsForTemplate.put(poolId, weight);
    }
}

