/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.ChainModel;
import twilightforest.client.model.entity.SpikeBlockModel;
import twilightforest.entity.projectile.ChainBlock;

public class BlockChainRenderer
extends EntityRenderer<ChainBlock> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("block_and_chain.png");
    private final Model model;
    private final Model chainModel;

    public BlockChainRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpikeBlockModel(context.bakeLayer(TFModelLayers.CHAIN_BLOCK));
        this.chainModel = new ChainModel(context.bakeLayer(TFModelLayers.CHAIN));
    }

    public void render(ChainBlock entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        super.render((Entity)entity, yaw, partialTicks, stack, buffer, light);
        stack.pushPose();
        VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(TEXTURE), (boolean)false, (boolean)entity.isFoil());
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        stack.scale(-1.0f, -1.0f, 1.0f);
        this.model.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
        Entity owner = entity.getOwner();
        if (owner != null) {
            stack.pushPose();
            stack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
            Vec3 xyz = owner.getEyePosition(partialTicks).subtract(entity.getPosition(partialTicks).add(0.0, (double)owner.getBbHeight() * 0.5, 0.0));
            double linksPerMeter = 1.5;
            double links = xyz.length() / linksPerMeter;
            Vec3 offset = xyz.normalize().scale(-linksPerMeter);
            int ownerLight = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(owner, partialTicks);
            int i = 1;
            while ((double)i < links) {
                BlockChainRenderer.renderChain((Entity)entity, xyz.add(offset.scale(links - (double)i)), stack, buffer, Math.max(light, ownerLight), this.chainModel);
                ++i;
            }
            stack.popPose();
        }
    }

    public static void renderChain(Entity entity, Vec3 offset, PoseStack stack, MultiBufferSource buffer, int light, Model chainModel) {
        VertexConsumer vertexConsumer;
        stack.pushPose();
        if (entity instanceof ChainBlock) {
            ChainBlock block = (ChainBlock)entity;
            vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)chainModel.renderType(TEXTURE), (boolean)false, (boolean)block.isFoil());
        } else {
            vertexConsumer = buffer.getBuffer(chainModel.renderType(TEXTURE));
        }
        stack.translate(offset.x(), offset.y(), offset.z());
        stack.scale(-1.0f, -1.0f, 1.0f);
        chainModel.renderToBuffer(stack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(ChainBlock entity) {
        return TEXTURE;
    }
}

