/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.block.TrophyWallBlock;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.AlphaYetiModel;
import twilightforest.client.model.entity.HydraHeadModel;
import twilightforest.client.model.entity.KnightPhantomModel;
import twilightforest.client.model.entity.LichModel;
import twilightforest.client.model.entity.MinoshroomModel;
import twilightforest.client.model.entity.NagaModel;
import twilightforest.client.model.entity.QuestRamModel;
import twilightforest.client.model.entity.SnowQueenModel;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.model.entity.UrGhastModel;
import twilightforest.enums.BossVariant;
import twilightforest.init.TFBlocks;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private final Map<BossVariant, TrophyBlockModel> trophies;
    public static final ItemStack stack = new ItemStack((ItemLike)TFBlocks.NAGA_TROPHY.get());

    public TrophyRenderer(BlockEntityRendererProvider.Context context) {
        this.trophies = TrophyRenderer.createTrophyRenderers(context.getModelSet());
    }

    public static Map<BossVariant, TrophyBlockModel> createTrophyRenderers(EntityModelSet set) {
        ImmutableMap.Builder trophyList = ImmutableMap.builder();
        trophyList.put((Object)BossVariant.NAGA, new NagaModel(set.bakeLayer(TFModelLayers.NAGA_TROPHY)));
        trophyList.put((Object)BossVariant.LICH, new LichModel(set.bakeLayer(TFModelLayers.LICH_TROPHY)));
        trophyList.put((Object)BossVariant.MINOSHROOM, new MinoshroomModel(set.bakeLayer(TFModelLayers.MINOSHROOM_TROPHY)));
        trophyList.put((Object)BossVariant.HYDRA, new HydraHeadModel(set.bakeLayer(TFModelLayers.HYDRA_TROPHY)));
        trophyList.put((Object)BossVariant.KNIGHT_PHANTOM, (Object)new KnightPhantomModel(set.bakeLayer(TFModelLayers.KNIGHT_PHANTOM_TROPHY)));
        trophyList.put((Object)BossVariant.UR_GHAST, (Object)new UrGhastModel(set.bakeLayer(TFModelLayers.UR_GHAST_TROPHY)));
        trophyList.put((Object)BossVariant.ALPHA_YETI, (Object)new AlphaYetiModel(set.bakeLayer(TFModelLayers.ALPHA_YETI_TROPHY)));
        trophyList.put((Object)BossVariant.SNOW_QUEEN, (Object)new SnowQueenModel(set.bakeLayer(TFModelLayers.SNOW_QUEEN_TROPHY)));
        trophyList.put((Object)BossVariant.QUEST_RAM, new QuestRamModel(set.bakeLayer(TFModelLayers.QUEST_RAM_TROPHY)));
        return trophyList.build();
    }

    public void render(TrophyBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        float f = entity.getAnimationProgress(partialTicks);
        BlockState blockstate = entity.getBlockState();
        boolean flag = blockstate.getBlock() instanceof TrophyWallBlock;
        Direction direction = flag ? (Direction)blockstate.getValue((Property)TrophyWallBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.get2DDataValue()) * 4 : (Integer)blockstate.getValue((Property)TrophyBlock.ROTATION));
        BossVariant variant = ((AbstractTrophyBlock)blockstate.getBlock()).getVariant();
        TrophyBlockModel model = this.trophies.get((Object)variant);
        TrophyRenderer.render(direction, f1, model, variant, f, stack, buffer, light, ItemDisplayContext.NONE);
    }

    public static void render(@Nullable Direction direction, float y, TrophyBlockModel model, BossVariant variant, float animationProgress, PoseStack stack, MultiBufferSource buffer, int light, ItemDisplayContext context) {
        stack.pushPose();
        if (direction == null || variant == BossVariant.UR_GHAST) {
            stack.translate(0.5, 0.0, 0.5);
        } else {
            stack.translate((double)(0.5f - (float)direction.getStepX() * 0.249f), 0.25, (double)(0.5f - (float)direction.getStepZ() * 0.249f));
        }
        stack.scale(-1.0f, -1.0f, 1.0f);
        model.setupRotationsForTrophy(animationProgress * 4.5f, y, 0.0f, context == ItemDisplayContext.GUI ? 0.35f : (direction != null ? 0.5f : 0.0f));
        model.renderTrophy(stack, buffer, light, OverlayTexture.NO_OVERLAY, -1, context);
        stack.popPose();
    }
}

