/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.CarminiteGolem;

public class CarminiteGolemModel<T extends CarminiteGolem>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public CarminiteGolemModel(ModelPart root) {
        this.root = root;
        this.head = this.root.getChild("head");
        this.rightArm = this.root.getChild("right_arm");
        this.leftArm = this.root.getChild("left_arm");
        this.rightLeg = this.root.getChild("right_leg");
        this.leftLeg = this.root.getChild("left_leg");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -10.0f, -3.0f, 7.0f, 8.0f, 6.0f).texOffs(0, 14).addBox(-4.0f, -6.0f, -3.5f, 8.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)-11.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-8.0f, 0.0f, -5.0f, 16.0f, 10.0f, 10.0f), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("ribs", CubeListBuilder.create().texOffs(0, 46).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(52, 0).addBox(-5.0f, -2.0f, -1.5f, 3.0f, 14.0f, 3.0f).texOffs(52, 17).addBox(-7.0f, 12.0f, -3.0f, 6.0f, 12.0f, 6.0f).texOffs(52, 36).addBox(-7.0f, -3.0f, -3.5f, 7.0f, 2.0f, 7.0f).texOffs(52, 45).addBox(-7.0f, -1.0f, -3.5f, 7.0f, 5.0f, 2.0f).texOffs(52, 45).addBox(-7.0f, -1.0f, 1.5f, 7.0f, 5.0f, 2.0f).texOffs(52, 54).addBox(-2.0f, -1.0f, -2.0f, 2.0f, 5.0f, 3.0f), PartPose.offset((float)-8.0f, (float)-12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(52, 0).addBox(2.0f, -2.0f, -1.5f, 3.0f, 14.0f, 3.0f).texOffs(52, 17).addBox(1.0f, 12.0f, -3.0f, 6.0f, 12.0f, 6.0f).texOffs(52, 36).addBox(0.0f, -3.0f, -3.5f, 7.0f, 2.0f, 7.0f).texOffs(52, 45).addBox(0.0f, -1.0f, -3.5f, 7.0f, 5.0f, 2.0f).texOffs(52, 45).addBox(0.0f, -1.0f, 1.5f, 7.0f, 5.0f, 2.0f).texOffs(52, 54).addBox(0.0f, -1.0f, -2.0f, 2.0f, 5.0f, 3.0f), PartPose.offset((float)8.0f, (float)-12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hips", CubeListBuilder.create().texOffs(84, 25).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(84, 18).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(84, 32).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f).texOffs(84, 43).addBox(-5.5f, 8.0f, -4.0f, 6.0f, 14.0f, 7.0f), PartPose.offset((float)-1.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(84, 32).addBox(0.0f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f).texOffs(84, 43).addBox(-0.5f, 8.0f, -4.0f, 6.0f, 14.0f, 7.0f), PartPose.offset((float)1.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.rightArm.zRot = Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftArm.zRot = -Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int timer = ((CarminiteGolem)((Object)entity)).getAttackTimer();
        if (timer > 0) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)timer - partialTicks), (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)timer - partialTicks), (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }
}

