/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.vehicle.Boat;

public class TextureGeneratorReloadListener
implements ResourceManagerReloadListener {
    public static final TextureGeneratorReloadListener INSTANCE = new TextureGeneratorReloadListener();
    private static final EnumMap<Boat.Type, AbstractTexture> BOAT_CACHE = new EnumMap(Boat.Type.class);
    private static final AtomicReference<NativeImage> ref = new AtomicReference();

    public void onResourceManagerReload(ResourceManager manager) {
        ResourceLocation oak = TextureGeneratorReloadListener.getTextureLocation(Boat.Type.OAK);
        manager.getResource(oak).ifPresent(vanillaResource -> {
            try (InputStream vanillaStream = vanillaResource.open();
                 NativeImage vanillaImage = NativeImage.read((InputStream)vanillaStream);){
                int defaultScale = 128;
                int vanillaScale = vanillaImage.getWidth() / defaultScale;
                for (Boat.Type type : Boat.Type.values()) {
                    ResourceLocation location = TextureGeneratorReloadListener.getTextureLocation(type);
                    if (!location.getNamespace().equals("twilightforest")) continue;
                    manager.getResource(location).ifPresent(tfResource -> {
                        block32: {
                            try (InputStream tfStream = tfResource.open();
                                 NativeImage tfImage = NativeImage.read((InputStream)tfStream);){
                                int y;
                                int x;
                                int tfScale = tfImage.getWidth() / defaultScale;
                                for (x = 0; x < 48 * tfScale; ++x) {
                                    for (y = 58 * tfScale; y < 96 * tfScale; ++y) {
                                        if (tfImage.getPixelRGBA(x, y) == 0) continue;
                                        return;
                                    }
                                }
                                if (vanillaScale > tfScale) {
                                    try (NativeImage newImage = new NativeImage(defaultScale * vanillaScale, defaultScale * vanillaScale, false);){
                                        newImage.copyFrom(vanillaImage);
                                        for (int x2 = 0; x2 < 102 * vanillaScale; ++x2) {
                                            for (int y2 = 0; y2 < 52 * vanillaScale; ++y2) {
                                                newImage.setPixelRGBA(x2, y2, tfImage.getPixelRGBA(x2 / (vanillaScale / tfScale), y2 / (vanillaScale / tfScale)));
                                            }
                                        }
                                        ref.set(newImage);
                                        if (BOAT_CACHE.containsKey(type)) {
                                            BOAT_CACHE.get(type).load(manager);
                                        } else {
                                            AbstractTexture texture = new AbstractTexture(this){

                                                public void load(ResourceManager resourceManager) {
                                                    if (ref.get() == null) {
                                                        return;
                                                    }
                                                    TextureUtil.prepareImage((int)this.getId(), (int)0, (int)ref.get().getWidth(), (int)ref.get().getHeight());
                                                    ref.get().upload(0, 0, 0, 0, 0, ref.get().getWidth(), ref.get().getHeight(), false, false, false, true);
                                                }
                                            };
                                            Minecraft.getInstance().getTextureManager().register(location, texture);
                                            BOAT_CACHE.put(type, texture);
                                        }
                                        break block32;
                                    }
                                }
                                for (x = 0; x < 48 * tfScale; ++x) {
                                    for (y = 58 * tfScale; y < 96 * tfScale; ++y) {
                                        tfImage.setPixelRGBA(x, y, vanillaImage.getPixelRGBA(x / (tfScale / vanillaScale), y / (tfScale / vanillaScale)));
                                    }
                                }
                                ref.set(tfImage);
                                if (BOAT_CACHE.containsKey(type)) {
                                    BOAT_CACHE.get(type).load(manager);
                                } else {
                                    AbstractTexture texture = new AbstractTexture(this){

                                        public void load(ResourceManager resourceManager) {
                                            if (ref.get() == null) {
                                                return;
                                            }
                                            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)ref.get().getWidth(), (int)ref.get().getHeight());
                                            ref.get().upload(0, 0, 0, 0, 0, ref.get().getWidth(), ref.get().getHeight(), false, false, false, true);
                                        }
                                    };
                                    Minecraft.getInstance().getTextureManager().register(location, texture);
                                    BOAT_CACHE.put(type, texture);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        ref.set(null);
    }

    private static ResourceLocation getTextureLocation(Boat.Type type) {
        return ResourceLocation.parse((String)type.getName()).withPrefix("textures/entity/chest_boat/").withSuffix(".png");
    }
}

