/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;
import twilightforest.util.WorldUtil;

public class TransLogCoreBlock
extends SpecialMagicLogBlock {
    public TransLogCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean doesCoreFunction() {
        return !TFConfig.disableTransformationCore;
    }

    @Override
    void performTreeEffect(ServerLevel level, BlockPos pos, RandomSource rand) {
        ResourceKey<Biome> target = TFBiomes.ENCHANTED_FOREST;
        Holder.Reference biome = level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(target);
        int range = TFConfig.transformationCoreRange;
        for (int i = 0; i < 16; ++i) {
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, range, 0, range);
            if (dPos.distSqr((Vec3i)pos) > 256.0 || level.getBiome(dPos).is(target)) continue;
            int minY = QuartPos.fromBlock((int)level.getMinBuildHeight());
            int maxY = minY + QuartPos.fromBlock((int)level.getHeight()) - 1;
            int x = QuartPos.fromBlock((int)dPos.getX());
            int z = QuartPos.fromBlock((int)dPos.getZ());
            LevelChunk chunkAt = level.getChunk(dPos.getX() >> 4, dPos.getZ() >> 4);
            for (LevelChunkSection section : chunkAt.getSections()) {
                for (int sy = 0; sy < 16; sy += 4) {
                    PalettedContainerRO palettedContainerRO;
                    int y = Mth.clamp((int)QuartPos.fromBlock((int)(chunkAt.getMinSection() + sy)), (int)minY, (int)maxY);
                    if (((Holder)section.getBiomes().get(x & 3, y & 3, z & 3)).is(target) || !((palettedContainerRO = section.getBiomes()) instanceof PalettedContainer)) continue;
                    PalettedContainer container = (PalettedContainer)palettedContainerRO;
                    container.set(x & 3, y & 3, z & 3, (Object)biome);
                }
            }
            if (!chunkAt.isUnsaved()) {
                chunkAt.setUnsaved(true);
            }
            level.getChunkSource().chunkMap.resendBiomesForChunks(List.of(chunkAt));
            Vec3 xyz = Vec3.atCenterOf((Vec3i)dPos);
            ParticlePacket particlePacket = new ParticlePacket();
            for (int j = 0; j < 9; ++j) {
                float angle = rand.nextFloat() * 360.0f;
                Vec3 offset = new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).scale(2.0);
                particlePacket.queueParticle((ParticleOptions)TFParticleType.TRANSFORMATION_PARTICLE.get(), false, xyz.add(offset), Vec3.ZERO.subtract(offset));
            }
            PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)xyz.x(), (double)xyz.y(), (double)xyz.z(), (double)64.0, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            break;
        }
    }

    @Override
    protected void playSound(Level level, BlockPos pos, RandomSource rand) {
        level.playSound(null, pos, (SoundEvent)TFSounds.TRANSFORMATION_CORE.get(), SoundSource.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
    }
}

