/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.entity.JarBlockEntity;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class JarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<JarBlock> CODEC = JarBlock.simpleCodec(JarBlock::new);
    private static final VoxelShape JAR = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final VoxelShape LID = Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape AABB = Shapes.or((VoxelShape)JAR, (VoxelShape)LID);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public JarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        return superState == null ? null : (BlockState)superState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public Item getDefaultLid() {
        return TFBlocks.TWILIGHT_OAK_LOG.asItem();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity jarBlockEntity = (JarBlockEntity)blockEntity;
            itemStack = jarBlockEntity.getJarAsItem();
        } else {
            itemStack = super.getCloneItemStack(state, target, level, pos, player);
        }
        return itemStack;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof JarBlockEntity) {
            JarBlockEntity jarBlockEntity = (JarBlockEntity)((Object)object);
            params = params.withDynamicDrop(JarBlockEntity.JAR_LID, stackConsumer -> stackConsumer.accept(jarBlockEntity.lid.getDefaultInstance()));
        }
        return super.getDrops(state, params);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JarBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JarBlockEntity) {
            BooleanSupplier check;
            BooleanSupplier booleanSupplier;
            Item lid;
            JarBlockEntity jarBlockEntity = (JarBlockEntity)blockEntity;
            if (hitResult.getLocation().y >= (double)pos.getY() + 0.875 && (lid = stack.getItem()) != jarBlockEntity.lid && (booleanSupplier = JarBlockEntity.REGISTERED_LOG_LIDS.get(lid)) instanceof BooleanSupplier && (check = booleanSupplier).getAsBoolean()) {
                jarBlockEntity.lid = lid;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_LID_SWAP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    jarBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                    jarBlockEntity.setChanged();
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity blockEntity2 = (JarBlockEntity)blockEntity;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && player.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_WIGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    blockEntity2.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

