/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.TFSmokerBlock;
import twilightforest.init.TFSounds;

public class EncasedSmokerBlock
extends TFSmokerBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public EncasedSmokerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        boolean powered = level.hasNeighborSignal(pos);
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && powered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            level.playSound(null, pos, (SoundEvent)TFSounds.SMOKER_START.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        }
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && !powered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            level.playSound(null, pos, (SoundEvent)TFSounds.SMOKER_START.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        }
    }
}

