/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.init.TFAdvancements;

public class KillBugTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockState bug) {
        this.trigger(player, instance -> instance.matches(bug));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Block> bugType) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("bug").forGetter(TriggerInstance::bugType)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> killBug(Block bug) {
            return ((KillBugTrigger)((Object)TFAdvancements.KILL_BUG.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(bug)));
        }

        public boolean matches(BlockState bug) {
            return this.bugType.isEmpty() || bug.is(this.bugType.get());
        }
    }
}

