/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.ctt;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class WorkerThread {
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private final Thread worker;

    public WorkerThread(String name) {
        this.worker = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Runnable task = this.taskQueue.take();
                    task.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, name);
        this.worker.start();
    }

    public Future<?> submitTask(Runnable task) {
        CompletableFuture future = new CompletableFuture();
        this.taskQueue.offer(() -> {
            try {
                task.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public void shutdown() {
        this.worker.interrupt();
    }
}

