/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.google.common.collect.Sets;
import com.scouter.oceansdelight.datagen.BlockTagsGenerator;
import com.scouter.oceansdelight.datagen.BlockstateGenerator;
import com.scouter.oceansdelight.datagen.ItemModelGenerator;
import com.scouter.oceansdelight.datagen.LanguageGenerator;
import com.scouter.oceansdelight.datagen.RecipeGenerator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="oceansdelight", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        HashSet set = Sets.newHashSet();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        BlockTagsGenerator blockTagGenerator = (BlockTagsGenerator)generator.addProvider(evt.includeServer(), (DataProvider)new BlockTagsGenerator(generator.getPackOutput(), lookupProvider, helper));
        Consumer<BlockStateGenerator> consumer = set::add;
        generator.addProvider(true, (DataProvider)new BlockstateGenerator(generator.getPackOutput(), helper));
        generator.addProvider(true, (DataProvider)new LanguageGenerator(generator));
        generator.addProvider(true, (DataProvider)new RecipeGenerator(generator.getPackOutput(), lookupProvider));
        generator.addProvider(true, (DataProvider)new ItemModelGenerator(generator.getPackOutput(), helper));
    }
}

