/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ModCakeBlock
extends CakeBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public final Supplier<Item> pieSlice;

    public ModCakeBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
    }

    public int getMaxBites() {
        return 7;
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)this.pieSlice.get());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.consumeBite(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.getItem().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            for (FoodProperties.PossibleEffect effect : sliceFood.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        if ((bites = ((Integer)state.getValue((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        level.playSound((Player)null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = player.getDirection().getOpposite();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        level.playSound((Player)null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState State, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = SHAPE_BY_BITE[(Integer)State.getValue((Property)BITES)];
        Direction facing = (Direction)State.getValue((Property)FACING);
        if (facing == Direction.EAST) {
            return this.rotateShape(baseShape, Direction.EAST);
        }
        if (facing == Direction.SOUTH) {
            return this.rotateShape(baseShape, Direction.SOUTH);
        }
        if (facing == Direction.WEST) {
            return this.rotateShape(baseShape, Direction.WEST);
        }
        return baseShape;
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (direction.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BITES});
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return heldStack.is(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

