/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.CCUniform;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.UniformPair;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;

public class ShaderProgram
implements ResourceManagerReloadListener {
    private final List<ShaderObject> shaders;
    private final Map<String, CCUniform> uniforms;
    @Nullable
    private final Runnable applyCallback;
    private int programId = -1;
    private boolean bound;

    ShaderProgram(Collection<ShaderObject> shaders, Collection<UniformPair> uniforms, @Nullable Runnable applyCallback) {
        this.shaders = ImmutableList.copyOf(shaders);
        this.uniforms = FastStream.of(uniforms).toImmutableMap(UniformPair::name, e -> CCUniform.makeUniform(e.name(), e.type(), e.type().getSize(), null));
        this.applyCallback = applyCallback;
    }

    public List<ShaderObject> getShaders() {
        return this.shaders;
    }

    public Map<String, CCUniform> getUniforms() {
        return this.uniforms;
    }

    @Nullable
    public CCUniform getUniform(String name) {
        return this.uniforms.get(name);
    }

    public int getProgramId() {
        return this.programId;
    }

    public void use() {
        if (this.bound) {
            throw new IllegalStateException("Already bound.");
        }
        this.compile();
        GL20.glUseProgram((int)this.programId);
        if (this.applyCallback != null) {
            this.applyCallback.run();
        }
        this.bound = true;
    }

    public void compile() {
        if (this.programId != -1 && this.shaders.stream().noneMatch(ShaderObject::isDirty)) {
            return;
        }
        for (ShaderObject shaderObject : this.shaders) {
            shaderObject.alloc();
        }
        if (this.programId == -1) {
            this.programId = GL20.glCreateProgram();
            if (this.programId == 0) {
                throw new IllegalStateException("Allocation of ShaderProgram has failed.");
            }
            this.shaders.forEach(shader -> GL20.glAttachShader((int)this.programId, (int)shader.getShaderID()));
        }
        GL20.glLinkProgram((int)this.programId);
        if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
            throw new RuntimeException("ShaderProgram linkage failure. \n" + GL20.glGetProgramInfoLog((int)this.programId));
        }
        for (ShaderObject shader2 : this.shaders) {
            shader2.onLink(this.programId);
        }
        for (CCUniform value : this.uniforms.values()) {
            value.setLocation(GL20.glGetUniformLocation((int)this.programId, (CharSequence)value.getName()));
        }
    }

    public void release() {
        if (!this.bound) {
            throw new IllegalStateException("Not bound");
        }
        this.bound = false;
        GL20.glUseProgram((int)0);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        for (ShaderObject shader : this.shaders) {
            if (!(shader instanceof ResourceManagerReloadListener)) continue;
            ((ResourceManagerReloadListener)shader).onResourceManagerReload(resourceManager);
        }
        this.compile();
    }
}

