/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.raytracer.VoxelShapeBlockHitResult;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Matrix4;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.NeoForge;

public class CCRenderEventHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    public static int renderTime;
    public static float renderFrame;

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(CCRenderEventHandler::clientTick);
        NeoForge.EVENT_BUS.addListener(CCRenderEventHandler::renderTick);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CCRenderEventHandler::onBlockHighlight);
    }

    private static void clientTick(ClientTickEvent.Post event) {
        ++renderTime;
    }

    private static void renderTick(RenderFrameEvent.Pre event) {
        renderFrame = event.getPartialTick().getGameTimeDeltaPartialTick(true);
    }

    private static void onBlockHighlight(RenderHighlightEvent.Block event) {
        BlockHitResult hit = event.getTarget();
        if (hit instanceof VoxelShapeBlockHitResult) {
            VoxelShapeBlockHitResult voxelHit = (VoxelShapeBlockHitResult)hit;
            event.setCanceled(true);
            Matrix4 mat = new Matrix4(event.getPoseStack());
            mat.translate((Vec3i)voxelHit.getBlockPos());
            RenderUtils.bufferShapeHitBox(mat, event.getMultiBufferSource(), event.getCamera(), voxelHit.shape);
        }
    }
}

