/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.data.AbstractDataStore;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidData
extends AbstractDataStore<FluidStack> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluidData.class);

    public FluidData() {
        super(FluidStack.EMPTY);
    }

    public FluidData(FluidStack defaultValue) {
        super(defaultValue);
    }

    @Override
    public void set(FluidStack value) {
        this.value = value.copy();
        this.markDirty();
    }

    @Override
    public void toBytes(MCDataOutput buf) {
        buf.writeFluidStack((FluidStack)this.value);
    }

    @Override
    public void fromBytes(MCDataInput buf) {
        this.value = buf.readFluidStack();
    }

    @Override
    public Tag toTag(HolderLookup.Provider holders) {
        return (Tag)FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)holders.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((FluidStack)this.value)).getOrThrow();
    }

    @Override
    public void fromTag(HolderLookup.Provider holders, Tag tag) {
        this.value = FluidStack.OPTIONAL_CODEC.parse((DynamicOps)holders.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }

    @Override
    public boolean isSameValue(FluidStack newValue) {
        return ((FluidStack)this.value).equals(newValue);
    }
}

