/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryNBT
implements Container {
    protected final RegistryAccess registries;
    protected ItemStack[] items;
    protected CompoundTag tag;

    public InventoryNBT(RegistryAccess registries, int size, CompoundTag tag) {
        this.registries = registries;
        this.tag = tag;
        this.items = new ItemStack[size];
        ArrayUtils.fillArray(this.items, ItemStack.EMPTY, Objects::isNull);
        this.readNBT();
    }

    private void writeNBT() {
        this.tag.put("items", (Tag)InventoryUtils.writeItemStacksToTag((HolderLookup.Provider)this.registries, this.items, this.getMaxStackSize()));
    }

    private void readNBT() {
        if (this.tag.contains("items")) {
            InventoryUtils.readItemStacksFromTag((HolderLookup.Provider)this.registries, this.items, this.tag.getList("items", 10));
        }
    }

    public int getContainerSize() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return ArrayUtils.count(this.items, stack -> !stack.isEmpty()) <= 0;
    }

    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    public ItemStack removeItem(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.setChanged();
    }

    public void setChanged() {
        this.writeNBT();
    }

    public void clearContent() {
        Arrays.fill(this.items, ItemStack.EMPTY);
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

