/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.network;

import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Vector3;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    @Override
    public void handlePacket(PacketCustom packet, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                BlockPos pos = packet.readPos();
                Vector3 vec = packet.readVector();
                int numParticles = packet.readVarInt();
                BlockState state = Objects.requireNonNull(mc.level).getBlockState(pos);
                CustomParticleHandler.addLandingEffects((Level)mc.level, pos, state, vec, numParticles);
                break;
            }
            case 20: {
                ModularGuiContainerMenu.handlePacketFromServer((Player)Objects.requireNonNull(mc.player), packet);
            }
        }
    }
}

