/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class MiscCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)Commands.literal((String)"meminfo").requires(e -> e.hasPermission(4))).executes(MiscCommands::printMemInfo))).then(((LiteralArgumentBuilder)Commands.literal((String)"gc").requires(e -> e.hasPermission(4))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.gc.before"), true);
            MiscCommands.printMemInfo((CommandContext<CommandSourceStack>)ctx, true);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.gc.performing"), true);
            System.gc();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.gc.after"), true);
            MiscCommands.printMemInfo((CommandContext<CommandSourceStack>)ctx, true);
            return 0;
        })));
    }

    private static int printMemInfo(CommandContext<CommandSourceStack> ctx) {
        return MiscCommands.printMemInfo(ctx, false);
    }

    private static int printMemInfo(CommandContext<CommandSourceStack> ctx, boolean indent) {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        Object mem = String.format("Mem: % 2d%% %03d/%03dMB", used * 100L / max, MiscCommands.bytesToMb(used), MiscCommands.bytesToMb(max));
        Object allocated = String.format("Allocated: % 2d%% %03dMB", total * 100L / max, MiscCommands.bytesToMb(total));
        if (indent) {
            mem = " " + (String)mem;
            allocated = " " + (String)allocated;
        }
        String finalMem = mem;
        String finalAllocated = allocated;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)finalMem), true);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)finalAllocated), true);
        return 0;
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

