/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.sprite;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ModAtlasHolder
implements PreparableReloadListener,
AutoCloseable {
    private final TextureAtlas textureAtlas;
    private final ResourceLocation atlasLocation;
    private final ResourceLocation atlasInfoLocation;
    private final String modid;

    public ModAtlasHolder(String modid, String atlasLocation, String atlasInfoLocation) {
        this.atlasInfoLocation = ResourceLocation.fromNamespaceAndPath((String)modid, (String)atlasInfoLocation);
        this.atlasLocation = ResourceLocation.fromNamespaceAndPath((String)modid, (String)atlasLocation);
        this.textureAtlas = new TextureAtlas(this.atlasLocation);
        this.modid = modid;
    }

    public void init() {
        Minecraft.getInstance().getTextureManager().register(this.textureAtlas.location(), (AbstractTexture)this.textureAtlas);
    }

    public ResourceLocation atlasLocation() {
        return this.atlasLocation;
    }

    public TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return this.textureAtlas.getSprite(resourceLocation);
    }

    @NotNull
    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier prepBarrier, ResourceManager resourceManager, ProfilerFiller profiler, ProfilerFiller profiler2, Executor executor, Executor executor2) {
        Objects.requireNonNull(prepBarrier);
        SpriteLoader spriteLoader = SpriteLoader.create((TextureAtlas)this.textureAtlas);
        return ((CompletableFuture)((CompletableFuture)spriteLoader.loadAndStitch((ResourceManager)new ModResourceManager(resourceManager, this.modid), this.atlasInfoLocation, 0, executor).thenCompose(SpriteLoader.Preparations::waitForUpload)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)prepBarrier).wait(arg_0))).thenAcceptAsync(preparations -> this.apply((SpriteLoader.Preparations)preparations, profiler2), executor2);
    }

    private void apply(SpriteLoader.Preparations preparations, ProfilerFiller profilerFiller) {
        profilerFiller.startTick();
        profilerFiller.push("upload");
        this.textureAtlas.upload(preparations);
        profilerFiller.pop();
        profilerFiller.endTick();
    }

    @Override
    public void close() {
        this.textureAtlas.clearTextureData();
    }

    public static class ModResourceManager
    implements ResourceManager {
        private final ResourceManager wrapped;
        private final String modid;

        public ModResourceManager(ResourceManager wrapped, String modid) {
            this.wrapped = wrapped;
            this.modid = modid;
        }

        public Map<ResourceLocation, Resource> listResources(String pPath, Predicate<ResourceLocation> pFilter) {
            return this.wrapped.listResources(pPath, pFilter.and(e -> e.getNamespace().equals(this.modid)));
        }

        public Set<String> getNamespaces() {
            return this.wrapped.getNamespaces();
        }

        public List<Resource> getResourceStack(ResourceLocation pLocation) {
            return this.wrapped.getResourceStack(pLocation);
        }

        public Map<ResourceLocation, List<Resource>> listResourceStacks(String pPath, Predicate<ResourceLocation> pFilter) {
            return this.wrapped.listResourceStacks(pPath, pFilter);
        }

        public Stream<PackResources> listPacks() {
            return this.wrapped.listPacks();
        }

        public Optional<Resource> getResource(ResourceLocation pLocation) {
            return this.wrapped.getResource(pLocation);
        }
    }
}

