/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.sprite;

import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.gui.modular.sprite.ModAtlasHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.Nullable;

public class GuiTextures {
    public static final GuiTextures CCL = new GuiTextures("codechickenlib");
    private final String modId;
    @Nullable
    private final ModAtlasHolder atlasHolder;
    private final Map<String, Material> materialCache = new HashMap<String, Material>();

    public GuiTextures(String modId) {
        this.modId = modId;
        this.atlasHolder = DatagenModLoader.isRunningDataGen() ? null : new ModAtlasHolder(modId, "textures/atlas/gui.png", "gui");
    }

    public void init(IEventBus modBus) {
        modBus.addListener(this::onRegisterReloadListeners);
    }

    private void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        this.getAtlasHolder().init();
        event.registerReloadListener((PreparableReloadListener)this.getAtlasHolder());
    }

    public ModAtlasHolder getAtlasHolder() {
        return Objects.requireNonNull(this.atlasHolder, "AtlasHolder not available when datagen is running.");
    }

    public Material get(String texture) {
        return this.materialCache.computeIfAbsent(this.modId + ":" + texture, e -> this.getUncached(texture));
    }

    public Material get(Supplier<String> texture) {
        return this.get(texture.get());
    }

    public Supplier<Material> getter(Supplier<String> texture) {
        return () -> this.get((String)texture.get());
    }

    public Material getUncached(String texture) {
        return new Material(this.getAtlasHolder().atlasLocation(), ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)("gui/" + texture)), this.getAtlasHolder()::getSprite);
    }
}

